/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.search.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.search.TokensMatchIndexService;
import com.tydic.commodity.search.bo.AnalyzerTokensBo;
import com.tydic.commodity.search.bo.TokensMatchIndexReqBO;
import com.tydic.commodity.search.bo.TokensMatchIndexRspBO;
import com.tydic.commodity.search.config.MallElasticsearchUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractTokensMatchIndexService<T>
implements TokensMatchIndexService {
    private static final Logger log = LoggerFactory.getLogger(AbstractTokensMatchIndexService.class);
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    protected String fields = "";
    protected String index = "";
    protected String type = "";

    @Override
    public TokensMatchIndexRspBO match(TokensMatchIndexReqBO reqBO) {
        TokensMatchIndexRspBO rspBO = new TokensMatchIndexRspBO();
        String endPoint = "/" + this.index + "/" + this.type + "/_msearch";
        String queryString = this.getQueryString(reqBO.getRows());
        if (log.isDebugEnabled()) {
            log.debug("source---->" + queryString);
        }
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            Response response = this.mallElasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            rspBO = this.dealCatalogResult(result);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private TokensMatchIndexRspBO dealCatalogResult(String result) {
        TokensMatchIndexRspBO rspBO = new TokensMatchIndexRspBO();
        JSONObject resultObj = JSON.parseObject((String)result);
        ArrayList matchResultBos = new ArrayList();
        rspBO.setMatchBos(matchResultBos);
        JSONArray matchArray = resultObj.getJSONArray("responses");
        matchArray.stream().forEach(jsonObject -> {
            JSONObject singleObject = (JSONObject)jsonObject;
            JSONObject hitsObj = (JSONObject)singleObject.get((Object)"hits");
            Integer total = hitsObj.getInteger("total");
            if (!total.equals(0)) {
                JSONArray listObject = hitsObj.getJSONArray("hits");
                if (log.isDebugEnabled()) {
                    log.debug("\u672c\u6b21\u5339\u914d\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
                }
                listObject.stream().forEach(sourceObject -> {
                    JSONObject hitResObject = (JSONObject)sourceObject;
                    JSONObject hitSourceObject = (JSONObject)hitResObject.get((Object)"_source");
                    this.constructListBos(hitSourceObject, matchResultBos);
                });
            }
        });
        return rspBO;
    }

    private String getQueryString(List<AnalyzerTokensBo> tokens) {
        StringBuffer querySb = new StringBuffer();
        for (AnalyzerTokensBo tokensBo : tokens) {
            String header = new JSONObject().toJSONString();
            JSONObject queryJson = new JSONObject();
            JSONObject matchJson = new JSONObject();
            JSONObject phrasalJson = new JSONObject();
            phrasalJson.put("query", (Object)tokensBo.getToken());
            phrasalJson.put("fields", (Object)this.fields.split(","));
            matchJson.put("multi_match", (Object)phrasalJson);
            queryJson.put("query", (Object)matchJson);
            String body = queryJson.toJSONString();
            querySb.append(header);
            querySb.append("\n");
            querySb.append(body);
            querySb.append("\n");
        }
        return querySb.toString();
    }

    abstract void constructListBos(JSONObject var1, List<T> var2);
}

