/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.search.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.search.AnalyzerTokensService;
import com.tydic.commodity.search.bo.AnalyzerTokensBo;
import com.tydic.commodity.search.bo.AnalyzerTokensReqBO;
import com.tydic.commodity.search.bo.AnalyzerTokensRspBO;
import com.tydic.commodity.search.config.MallElasticsearchUtil;
import com.tydic.commodity.search.config.MallEsConfig;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AnalyzerTokensServiceImpl
implements AnalyzerTokensService {
    private static final Logger log = LoggerFactory.getLogger(AnalyzerTokensServiceImpl.class);
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;

    @Override
    public AnalyzerTokensRspBO analyzer(AnalyzerTokensReqBO reqBO) {
        AnalyzerTokensRspBO rspBO = new AnalyzerTokensRspBO();
        if (StringUtils.isEmpty((Object)reqBO.getTokens())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        String analyzer = "ik_smart";
        JSONObject qryJson = new JSONObject();
        qryJson.put("analyzer", (Object)analyzer);
        qryJson.put("text", (Object)reqBO.getTokens());
        String result = this.mallElasticsearchUtil.getIndexAnalyze(this.mallEsConfig.getIndexName(), JSONObject.toJSONString((Object)qryJson));
        log.debug("\u5206\u8bcd\u5206\u6790\u7ed3\u679c\uff1a{}", (Object)result);
        if (StringUtils.isEmpty((Object)result)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        List tokensBoList = JSONObject.parseArray((String)JSONObject.parseObject((String)result).get((Object)"tokens").toString(), AnalyzerTokensBo.class);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(tokensBoList);
        return rspBO;
    }
}

