/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.search.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tydic.commodity.bo.ability.UccMallSearchBarEsRspInfo;
import com.tydic.commodity.bo.busi.CatalogMatchResultBo;
import com.tydic.commodity.enumType.IntentRecognitionServiceEnum;
import com.tydic.commodity.search.TokensMatchIndexService;
import com.tydic.commodity.search.bo.AnalyzerTokensBo;
import com.tydic.commodity.search.bo.ForecastCategoryInfoBO;
import com.tydic.commodity.search.bo.FrequencyHitBo;
import com.tydic.commodity.search.bo.TokensMatchIndexReqBO;
import com.tydic.commodity.search.bo.TokensMatchIndexRspBO;
import com.tydic.commodity.search.constant.FrequencyLinkHashMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="forecastCategoryService")
public class ForecastCategoryServiceImpl
implements TokensMatchIndexService {
    private static final Logger log = LoggerFactory.getLogger(ForecastCategoryServiceImpl.class);
    private final int WEIGHT = 10;
    private static final String HAS = "1";
    private static final String NOT = "0";

    @Override
    public TokensMatchIndexRspBO match(TokensMatchIndexReqBO reqBO) {
        log.debug("\u9884\u6d4b\u5206\u6790\u67e5\u8be2\u7ed3\u679c\u96c6\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        TokensMatchIndexRspBO rspBO = new TokensMatchIndexRspBO();
        if (CollectionUtils.isEmpty(reqBO.getResult())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        Integer forecastType = 0;
        boolean hasCateLog = !CollectionUtils.isEmpty((Collection)reqBO.getParamsMap().get(IntentRecognitionServiceEnum.CATALOG.name()));
        List<UccMallSearchBarEsRspInfo> searchBarEsBos = reqBO.getResult();
        ArrayList<ForecastCategoryInfoBO> forecastCategoryInfoBOS = new ArrayList<ForecastCategoryInfoBO>();
        for (UccMallSearchBarEsRspInfo uccMallSearchBarEsRspInfo : searchBarEsBos) {
            List categoryIds = uccMallSearchBarEsRspInfo.getL3CategoryId();
            List categoryNames = uccMallSearchBarEsRspInfo.getL3CategoryName();
            int size = Math.min(categoryIds.size(), categoryNames.size());
            if (categoryIds.isEmpty() || categoryNames.isEmpty()) continue;
            for (int i = 0; i < size; ++i) {
                ForecastCategoryInfoBO forecastCategoryInfoBO = new ForecastCategoryInfoBO();
                if (hasCateLog) {
                    forecastType = this.getForecastType(uccMallSearchBarEsRspInfo, reqBO.getParamsMap(), forecastType);
                    continue;
                }
                FrequencyHitBo frequencyHitBo = this.getFrequency(uccMallSearchBarEsRspInfo, reqBO, forecastType);
                forecastCategoryInfoBO.setFrequency(frequencyHitBo.getFrequency());
                forecastCategoryInfoBO.setHitRate(frequencyHitBo.getHitRate());
                forecastCategoryInfoBO.setTempL3CategoryId((Long)categoryIds.get(i));
                forecastCategoryInfoBO.setTempL3CategoryName((String)categoryNames.get(i));
                forecastCategoryInfoBOS.add(forecastCategoryInfoBO);
                forecastType = frequencyHitBo.getForecastType();
            }
        }
        if (hasCateLog) {
            rspBO.setMatchType(forecastType);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        return this.forecastCateLog(forecastCategoryInfoBOS, forecastType);
    }

    private TokensMatchIndexRspBO forecastCateLog(List<ForecastCategoryInfoBO> forecastCategoryInfoBOS, Integer forecastType) {
        TokensMatchIndexRspBO rspBO = new TokensMatchIndexRspBO();
        Map<Long, ForecastCategoryInfoBO> frequencyMap = forecastCategoryInfoBOS.stream().filter(a -> a.getTempL3CategoryId() != null).collect(Collectors.groupingBy(ForecastCategoryInfoBO::getTempL3CategoryId, Collectors.collectingAndThen(Collectors.maxBy(Comparator.comparing(ForecastCategoryInfoBO::getHitRate)), Optional::get)));
        List frequencyList = frequencyMap.entrySet().stream().map(e -> (ForecastCategoryInfoBO)e.getValue()).collect(Collectors.toList());
        log.info("\u53bb\u91cd\u9891\u9053\u524d\u7684\u96c6\u5408\u5927\u5c0f\uff1a" + frequencyList.size());
        List uniqueCategoryList = frequencyList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ForecastCategoryInfoBO>(Comparator.comparing(ForecastCategoryInfoBO::getTempL3CategoryName))), ArrayList::new));
        log.info("\u53bb\u91cd\u9891\u9053\u540e\u7684\u96c6\u5408\u5927\u5c0f\uff1a" + uniqueCategoryList.size());
        Map<Long, Long> frequencyTotalMap = this.getFrequencyTotalMap(forecastCategoryInfoBOS);
        List<ForecastCategoryInfoBO> resultList = uniqueCategoryList.stream().filter(e -> frequencyTotalMap.get(e.getTempL3CategoryId()) != null).sorted(Comparator.comparing(ForecastCategoryInfoBO::getHitRate).thenComparing(ForecastCategoryInfoBO::getFrequency).reversed()).limit(10L).collect(Collectors.toList());
        ArrayList matchResultBos = new ArrayList();
        resultList.forEach(forecastCategoryInfoBO -> {
            CatalogMatchResultBo matchResultBo = new CatalogMatchResultBo();
            matchResultBo.setGuideCatalogId(forecastCategoryInfoBO.getTempL3CategoryId());
            matchResultBo.setCatalogLevel(Long.valueOf(3L));
            matchResultBo.setTagName(forecastCategoryInfoBO.getTempL3CategoryName());
            matchResultBos.add(matchResultBo);
        });
        rspBO.setMatchType(forecastType);
        rspBO.setMatchBos(matchResultBos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FrequencyHitBo getFrequency(UccMallSearchBarEsRspInfo uccMallSearchBarEsRspInfo, TokensMatchIndexReqBO reqBO, Integer forecastType) {
        int i;
        forecastType = this.getForecastType(uccMallSearchBarEsRspInfo, reqBO.getParamsMap(), forecastType);
        List<AnalyzerTokensBo> rows = reqBO.getRows();
        FrequencyHitBo frequencyHitBo = new FrequencyHitBo();
        long frequency = 0L;
        int hitCount = 0;
        long[] tokenCount = new long[rows.size()];
        StringBuffer sbName = new StringBuffer();
        sbName.append(uccMallSearchBarEsRspInfo.getSkuName());
        sbName.append(uccMallSearchBarEsRspInfo.getExtendProperties());
        for (i = 0; i < rows.size(); ++i) {
            AnalyzerTokensBo tokensBo = rows.get(i);
            long count = this.appearFrequency(sbName.toString(), tokensBo.getToken());
            if (count > 0L) {
                ++hitCount;
            }
            tokenCount[i] = count;
        }
        for (i = 0; i < tokenCount.length; ++i) {
            frequency += tokenCount[i] * (long)this.fibonacci(i + 10);
        }
        frequencyHitBo.setFrequency(frequency);
        frequencyHitBo.setHitRate(new BigDecimal((float)hitCount / (float)rows.size()).setScale(2, 4).doubleValue());
        frequencyHitBo.setForecastType(forecastType);
        return frequencyHitBo;
    }

    private Integer getForecastType(UccMallSearchBarEsRspInfo uccMallSearchBarEsRspInfo, Map<String, List<String>> paramsMap, Integer forecastType) {
        String vendorName;
        String brandName;
        String forecastStr;
        String cateLogType = NOT;
        List<String> cateLogList = paramsMap.get(IntentRecognitionServiceEnum.CATALOG.name());
        if (!CollectionUtils.isEmpty(cateLogList)) {
            forecastStr = StringUtils.strip((String)cateLogList.toString(), (String)"[]").replace(" ", "");
            List categoryNames = uccMallSearchBarEsRspInfo.getL3CategoryName();
            for (String categoryName : categoryNames) {
                if (!forecastStr.contains(categoryName)) continue;
                cateLogType = HAS;
            }
        }
        String brandType = NOT;
        List<String> brandList = paramsMap.get(IntentRecognitionServiceEnum.BRAND.name());
        if (!CollectionUtils.isEmpty(brandList) && (forecastStr = StringUtils.strip((String)brandList.toString(), (String)"[]").replace(" ", "")).contains(brandName = uccMallSearchBarEsRspInfo.getBrandName())) {
            brandType = HAS;
        }
        String vendorType = NOT;
        List<String> vendorList = paramsMap.get(IntentRecognitionServiceEnum.VENDOR.name());
        if (!CollectionUtils.isEmpty(vendorList) && (forecastStr = StringUtils.strip((String)vendorList.toString(), (String)"[]").replace(" ", "")).contains(vendorName = uccMallSearchBarEsRspInfo.getVendorName())) {
            vendorType = HAS;
        }
        String str = cateLogType + brandType + vendorType;
        char[] charArray = str.toCharArray();
        int pos = charArray.length;
        int s = 0;
        for (int i = 0; i < pos; ++i) {
            int p = pos - i;
            int v = Integer.parseInt(String.valueOf(charArray[i]));
            s += new Double((double)v * Math.pow(10.0, p - 1)).intValue();
        }
        String binaryString = String.valueOf(s);
        Integer thisForecastType = Integer.parseInt(binaryString, 2);
        forecastType = Math.max(forecastType, thisForecastType);
        return forecastType;
    }

    private Long appearFrequency(String srcText, String findText) {
        Long count = 0L;
        Pattern p = Pattern.compile(findText);
        Matcher m = p.matcher(srcText);
        while (m.find()) {
            Long l = count;
            Long l2 = count = Long.valueOf(count + 1L);
        }
        return count;
    }

    private Map<Long, Long> getFrequencyTotalMap(List<ForecastCategoryInfoBO> forecastCategoryInfoBOS) {
        double postPercent = 0.3;
        Map<Long, Long> frequencyTotalMap = forecastCategoryInfoBOS.stream().collect(Collectors.groupingBy(ForecastCategoryInfoBO::getTempL3CategoryId, Collectors.counting()));
        FrequencyLinkHashMap frequencySeqMap = frequencyTotalMap.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, FrequencyLinkHashMap::new));
        int post = (int)Math.ceil((double)frequencySeqMap.size() * postPercent);
        FrequencyLinkHashMap deleteMap = new FrequencyLinkHashMap();
        for (int i = frequencySeqMap.size() - post; i < frequencySeqMap.size(); ++i) {
            FrequencyLinkHashMap map = new FrequencyLinkHashMap();
            Map.Entry entry = frequencySeqMap.getEntry(i);
            map.put(entry.getKey(), entry.getValue());
            deleteMap.putAll(map);
        }
        Set bigMapKey = frequencySeqMap.keySet();
        Set smallMapKey = deleteMap.keySet();
        Sets.SetView differenceSet = Sets.difference(bigMapKey, smallMapKey);
        HashMap resultMap = Maps.newHashMap();
        for (Long key : differenceSet) {
            resultMap.put(key, frequencySeqMap.get(key));
        }
        return resultMap;
    }

    int fibonacci(int n) {
        if (n <= 2) {
            return 1;
        }
        return this.fibonacci(n - 1) + this.fibonacci(n - 2);
    }
}

