/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common;

import com.tydic.common.dbService.DbDataSource;
import com.tydic.common.model.ExcelColumn;
import com.tydic.common.service.ImportExcelService;
import com.tydic.common.service.impl.ImportExcelServiceImpl;
import com.tydic.common.utils.ParseUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTool {
    private static final Logger log = LoggerFactory.getLogger(ImportTool.class);
    private ImportExcelService importExcelService = new ImportExcelServiceImpl();

    public List<String> importExcel(String path, DbDataSource dataSource, int mode) throws Exception {
        File file = new File(path);
        return this.importExcel(file, dataSource, mode);
    }

    public List<String> importExcel(File excelFile, DbDataSource dataSource, int mode) throws Exception {
        long start = System.currentTimeMillis();
        List<Map> checkList = this.checkExcel(excelFile);
        long end = System.currentTimeMillis();
        log.debug("\u6821\u9a8cExcel\u8017\u65f6\uff1a{} ", (Object)(end - start));
        if (mode > 0) {
            boolean clear = true;
            if (2 == mode) {
                clear = false;
            }
            for (Map sheetMap : checkList) {
                sheetMap.put("createTable", false);
                sheetMap.put("clearTable", clear);
            }
        }
        long start2 = System.currentTimeMillis();
        List<String> tableName = this.importToDb(excelFile, dataSource, checkList);
        long end2 = System.currentTimeMillis();
        log.debug("\u5165\u5e93\u8017\u65f6\uff1a{} ", (Object)(end2 - start2));
        return tableName;
    }

    public List<String> importExcel(String path, List<String> tableName, DbDataSource dataSource, int mode) throws Exception {
        File file = new File(path);
        return this.importExcel(file, tableName, dataSource, mode);
    }

    public List<String> importExcel(File excelFile, List<String> tableName, DbDataSource dataSource, int mode) throws Exception {
        long start = System.currentTimeMillis();
        List<Map> checkList = this.checkExcel(excelFile);
        long end = System.currentTimeMillis();
        log.debug("\u6821\u9a8cExcel\u8017\u65f6\uff1a{} ", (Object)(end - start));
        if (mode > 0) {
            boolean clear = true;
            if (2 == mode) {
                clear = false;
            }
            for (int i = 0; i < checkList.size(); ++i) {
                Map sheetMap = checkList.get(i);
                if (i < tableName.size() && StringUtils.isNotBlank((CharSequence)tableName.get(i))) {
                    sheetMap.put("tableName", tableName.get(i));
                }
                sheetMap.put("createTable", false);
                sheetMap.put("clearTable", clear);
            }
        }
        long start2 = System.currentTimeMillis();
        List<String> tableNameList = this.importToDb(excelFile, dataSource, checkList);
        long end2 = System.currentTimeMillis();
        log.debug("\u5165\u5e93\u8017\u65f6\uff1a{} ", (Object)(end2 - start2));
        return tableNameList;
    }

    public List<Map> checkExcel(String filePath) {
        File excelFile = new File(filePath);
        return this.checkExcel(excelFile);
    }

    /*
     * Exception decompiling
     */
    public List<Map> checkExcel(File excelFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Map> checkExcel(InputStream fileStream) throws Exception {
        return this.importExcelService.checkExcel(fileStream);
    }

    public List<Map> checkExcel(String filePath, DbDataSource dataSource, List<Map> reCheckList) {
        File excelFile = new File(filePath);
        return this.checkExcel(excelFile, dataSource, reCheckList);
    }

    public List<Map> checkExcel(File excelFile, DbDataSource dataSource, List<Map> reCheckList) {
        List<Map> checkList = this.importExcelService.checkExcel(excelFile, dataSource, reCheckList);
        return checkList;
    }

    public List<String> importToDb(String path, DbDataSource dataSource, List<Map> param) throws Exception {
        File excelFile = new File(path);
        return this.importToDb(excelFile, dataSource, param);
    }

    public List<String> importToDb(File excelFile, DbDataSource dataSource, List<Map> param) throws Exception {
        List<String> tableName = null;
        try (FileInputStream fis = new FileInputStream(excelFile);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            tableName = this.importToDb(bis, dataSource, param);
        }
        return tableName;
    }

    public List<String> importToDb(InputStream fileStream, DbDataSource dataSource, List<Map> param) throws Exception {
        for (Map item2 : param) {
            List tmpList = (List)item2.get("columnList");
            List<ExcelColumn> columnList = ParseUtils.mapToColumn(tmpList);
            item2.put("columnList", columnList);
        }
        this.importExcelService.importExcel(fileStream, dataSource, param);
        ArrayList<String> tableNameList = new ArrayList<String>();
        param.forEach(item -> tableNameList.add((String)item.get("tableName")));
        return tableNameList;
    }
}

