/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.analysis;

import com.tydic.common.dbService.DatabaseService;
import com.tydic.common.dbService.DbColumn;
import com.tydic.common.dbService.DbDataSource;
import com.tydic.common.dbService.factory.DatabaseServiceFactory;
import com.tydic.common.model.ExcelColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class CheckAnalysis {
    public Map<String, Object> analysis(Sheet sheet) throws Exception {
        int fieldRowIndex = sheet.getFirstRowNum();
        int firstDataRowIndex = fieldRowIndex + 1;
        int lastDataRowIndex = sheet.getLastRowNum();
        HashMap<String, Integer> sheetMap = new HashMap<String, Integer>();
        sheetMap.put("fieldRow", fieldRowIndex);
        sheetMap.put("firstDataRow", firstDataRowIndex);
        sheetMap.put("lastDataRow", lastDataRowIndex);
        return this.analysis(sheet, null, sheetMap);
    }

    public Map<String, Object> analysis(Sheet sheet, DbDataSource dataSource, Map reCheckList) throws Exception {
        String tableName;
        if (null == reCheckList) {
            reCheckList = new HashMap<String, Object>();
        }
        if (StringUtils.isBlank((CharSequence)(tableName = (String)reCheckList.get("tableName")))) {
            tableName = sheet.getSheetName();
            reCheckList.put("tableName", tableName);
        }
        int fieldRowIndex = 0;
        if (reCheckList.containsKey("fieldRow")) {
            fieldRowIndex = (Integer)reCheckList.get("fieldRow");
        }
        fieldRowIndex = fieldRowIndex < sheet.getFirstRowNum() ? sheet.getFirstRowNum() : fieldRowIndex;
        int firstDataRowIndex = fieldRowIndex + 1;
        if (reCheckList.containsKey("firstDataRow")) {
            firstDataRowIndex = (Integer)reCheckList.get("firstDataRow");
        }
        int lastDataRowIndex = 0;
        if (reCheckList.containsKey("lastDataRow")) {
            lastDataRowIndex = (Integer)reCheckList.get("lastDataRow");
        }
        lastDataRowIndex = lastDataRowIndex < firstDataRowIndex ? sheet.getLastRowNum() : lastDataRowIndex;
        Row titleRow = sheet.getRow(fieldRowIndex);
        Row firstDataRow = sheet.getRow(firstDataRowIndex);
        short firstDataColIndex = titleRow.getFirstCellNum() > firstDataRow.getFirstCellNum() ? firstDataRow.getFirstCellNum() : titleRow.getFirstCellNum();
        short lastDataColIndex = titleRow.getLastCellNum() < firstDataRow.getLastCellNum() ? firstDataRow.getLastCellNum() : titleRow.getLastCellNum();
        reCheckList.put("fieldRow", fieldRowIndex);
        reCheckList.put("firstDataRow", firstDataRowIndex);
        reCheckList.put("lastDataRow", lastDataRowIndex);
        reCheckList.put("firstDataCol", Integer.valueOf(firstDataColIndex));
        reCheckList.put("lastDataCol", Integer.valueOf(lastDataColIndex));
        boolean createTable = false;
        if (!reCheckList.containsKey("createTable")) {
            reCheckList.put("createTable", true);
            createTable = true;
        }
        if (!reCheckList.containsKey("clearTable")) {
            reCheckList.put("clearTable", true);
        }
        List<ExcelColumn> columnList = null;
        List<DbColumn> colNameList = null;
        if (null != dataSource && !createTable) {
            colNameList = this.getColList(dataSource, tableName);
        }
        columnList = this.analysisTitleCol(sheet, colNameList, fieldRowIndex, firstDataRowIndex, lastDataRowIndex, firstDataColIndex, lastDataColIndex);
        reCheckList.put("columnList", columnList);
        return reCheckList;
    }

    private List<DbColumn> getColList(DbDataSource dataSource, String tableName) throws Exception {
        String schema = dataSource.getDbName();
        DatabaseService databaseService = DatabaseServiceFactory.createDatabaseService(dataSource);
        List<DbColumn> columnList = null;
        try {
            columnList = databaseService.selectCol(schema, tableName);
        }
        catch (Exception e) {
            throw new Exception("\u83b7\u53d6\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25", e);
        }
        return columnList;
    }

    private List<ExcelColumn> analysisTitleCol(Sheet sheet, List<DbColumn> colNameList, int fieldRowIndex, int firstDataRowIndex, int lastDataRowIndex, int start, int end) {
        ArrayList<ExcelColumn> columnList = new ArrayList<ExcelColumn>();
        Row titleRow = sheet.getRow(fieldRowIndex);
        for (int colIndex = start; colIndex < end; ++colIndex) {
            Cell titleCell = titleRow.getCell(colIndex);
            String name = null;
            if (null != titleCell) {
                titleCell.setCellType(CellType.STRING);
                name = titleCell.getStringCellValue();
            }
            if (StringUtils.isBlank(name)) continue;
            ExcelColumn column = new ExcelColumn();
            column.setColumnName(name);
            column.setCommit(name);
            column.setOrder(colIndex - start);
            int tmpRow = firstDataRowIndex;
            Cell valueCell = sheet.getRow(tmpRow).getCell(colIndex);
            String type = "varchar(200)";
            while ((null == valueCell || CellType.BLANK == valueCell.getCellTypeEnum()) && tmpRow + 1 < lastDataRowIndex) {
                valueCell = sheet.getRow(++tmpRow).getCell(colIndex);
            }
            if (null != valueCell && CellType.BLANK != valueCell.getCellTypeEnum()) {
                type = this.analysisCellType(valueCell);
            }
            if (null != colNameList) {
                DbColumn tmp = null;
                String typePrefix = type.split("\\(")[0];
                for (DbColumn item : colNameList) {
                    if (!name.equals(item.getName()) || !item.getType().startsWith(typePrefix)) continue;
                    tmp = item;
                    break;
                }
                if (null != tmp) {
                    column.setName(tmp.getName());
                    column.setType(tmp.getType());
                } else {
                    column.setName(name);
                    column.setType(type);
                }
            } else {
                column.setName(name);
                column.setType(type);
            }
            columnList.add(column);
        }
        return columnList;
    }

    private String analysisCellType(Cell cell) {
        String type = "varchar(200)";
        if (CellType.NUMERIC == cell.getCellTypeEnum()) {
            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                type = cell.getCellStyle().getDataFormat() == 14 ? "date" : (cell.getCellStyle().getDataFormat() == 21 ? "time" : (cell.getCellStyle().getDataFormat() == 22 ? "datetime" : "datetime"));
            } else {
                cell.setCellType(CellType.STRING);
                String value = cell.getStringCellValue();
                String[] tmp = value.split("\\.");
                type = tmp.length == 1 ? "int(20)" : (Double.valueOf(tmp[1]) == 0.0 ? "int(20)" : "numeric(37, 4)");
            }
        }
        return type;
    }
}

