/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.analysis.v03;

import com.tydic.common.constant.ExcelDataType;
import com.tydic.common.constant.ExcelType;
import com.tydic.common.handle.SheetContentsHandler;
import com.tydic.common.utils.DataTypeUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.ptg.Ptg;

public class BaseHSSFListener
implements HSSFListener {
    private List<String> valueList;
    private List<ExcelDataType> typeList;
    private POIFSFileSystem fs;
    private int lastRowNumber;
    private int lastColumnNumber;
    private boolean outputFormulaValues = true;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private HSSFWorkbook stubWorkbook;
    private SSTRecord sstRecord;
    private FormatTrackingHSSFListener formatListener;
    private int nextRow;
    private int nextColumn;
    private boolean outputNextStringRecord;
    private int sheetIndex;
    private boolean notAllEmpty = false;
    private BoundSheetRecord[] orderedBSRs;
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private SheetContentsHandler handle;

    public BaseHSSFListener(SheetContentsHandler handle) {
        this.handle = handle;
        handle.setExcelType(ExcelType.XLS);
        this.valueList = new ArrayList<String>();
        this.typeList = new ArrayList<ExcelDataType>();
    }

    public void setFormatListener(FormatTrackingHSSFListener formatListener) {
        this.formatListener = formatListener;
    }

    public void processRecord(Record record) {
        int thisRow = -1;
        int thisColumn = -1;
        String thisStr = null;
        ExcelDataType thisType = null;
        switch (record.getSid()) {
            case 133: {
                this.boundSheetRecords.add((BoundSheetRecord)record);
                break;
            }
            case 2057: {
                BOFRecord br = (BOFRecord)record;
                if (br.getType() != 16) break;
                if (this.workbookBuildingListener != null && this.stubWorkbook == null) {
                    this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
                }
                if (this.orderedBSRs == null) {
                    this.orderedBSRs = BoundSheetRecord.orderByBofPosition(this.boundSheetRecords);
                }
                this.handle.endAllAnalysis();
                this.handle.setSheetIndex(this.sheetIndex);
                ++this.sheetIndex;
                this.handle.setSheetName(this.orderedBSRs[this.sheetIndex - 1].getSheetname());
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
            case 513: {
                BlankRecord brec = (BlankRecord)record;
                thisRow = brec.getRow();
                thisColumn = brec.getColumn();
                thisStr = "";
                thisType = ExcelDataType.NULL;
                break;
            }
            case 517: {
                BoolErrRecord berec = (BoolErrRecord)record;
                thisRow = berec.getRow();
                thisColumn = berec.getColumn();
                thisStr = "";
                if (berec.isBoolean()) {
                    thisType = ExcelDataType.BOOLEAN;
                    break;
                }
                thisType = ExcelDataType.ERROR;
                break;
            }
            case 6: {
                FormulaRecord frec = (FormulaRecord)record;
                thisRow = frec.getRow();
                thisColumn = frec.getColumn();
                if (this.outputFormulaValues) {
                    if (Double.isNaN(frec.getValue())) {
                        this.outputNextStringRecord = true;
                        this.nextRow = frec.getRow();
                        this.nextColumn = frec.getColumn();
                    } else {
                        thisStr = this.formatListener.formatNumberDateCell((CellValueRecordInterface)frec);
                    }
                } else {
                    thisStr = HSSFFormulaParser.toFormulaString((HSSFWorkbook)this.stubWorkbook, (Ptg[])frec.getParsedExpression());
                }
                thisType = ExcelDataType.DOUBLE;
                break;
            }
            case 519: {
                if (!this.outputNextStringRecord) break;
                StringRecord srec = (StringRecord)record;
                thisStr = srec.getString();
                thisType = ExcelDataType.STRING;
                thisRow = this.nextRow;
                thisColumn = this.nextColumn;
                this.outputNextStringRecord = false;
                break;
            }
            case 516: {
                LabelRecord lrec = (LabelRecord)record;
                thisRow = lrec.getRow();
                thisColumn = lrec.getColumn();
                thisStr = lrec.getValue();
                thisType = ExcelDataType.STRING;
                break;
            }
            case 253: {
                LabelSSTRecord lsrec = (LabelSSTRecord)record;
                thisRow = lsrec.getRow();
                thisColumn = lsrec.getColumn();
                thisStr = this.sstRecord == null ? "" : this.sstRecord.getString(lsrec.getSSTIndex()).toString();
                thisType = ExcelDataType.STRING;
                break;
            }
            case 28: {
                NoteRecord nrec = (NoteRecord)record;
                thisRow = nrec.getRow();
                thisColumn = nrec.getColumn();
                thisStr = "(TODO)";
                thisType = ExcelDataType.STRING;
                break;
            }
            case 515: {
                NumberRecord numrec = (NumberRecord)record;
                thisRow = numrec.getRow();
                thisColumn = numrec.getColumn();
                thisStr = this.formatListener.formatNumberDateCell((CellValueRecordInterface)numrec);
                String formatStr = this.formatListener.getFormatString((CellValueRecordInterface)numrec);
                thisType = DataTypeUtils.getTypeForNumber(thisStr, formatStr);
                thisStr = DataTypeUtils.fixDateType(thisStr, thisType, formatStr);
                break;
            }
            case 638: {
                RKRecord rkrec = (RKRecord)record;
                thisRow = rkrec.getRow();
                thisColumn = rkrec.getColumn();
                thisStr = "";
                break;
            }
        }
        if (thisRow != -1 && thisRow != this.lastRowNumber) {
            this.lastColumnNumber = -1;
        }
        if (record instanceof MissingCellDummyRecord) {
            MissingCellDummyRecord mc = (MissingCellDummyRecord)record;
            thisRow = mc.getRow();
            thisColumn = mc.getColumn();
            thisStr = "";
        }
        if (thisStr != null) {
            if (!"".equals(thisStr)) {
                this.notAllEmpty = true;
            }
            this.valueList.add(thisStr);
            this.typeList.add(thisType);
        }
        if (thisRow > -1) {
            this.lastRowNumber = thisRow;
        }
        if (thisColumn > -1) {
            this.lastColumnNumber = thisColumn;
        }
        if (record instanceof LastCellOfRowDummyRecord) {
            thisRow = ((LastCellOfRowDummyRecord)record).getRow();
            if (this.lastColumnNumber == -1) {
                this.lastColumnNumber = 0;
            }
            boolean has = false;
            for (String ite : this.valueList) {
                if (!StringUtils.isNotBlank((CharSequence)ite)) continue;
                has = true;
                break;
            }
            if (has) {
                this.handle.endRow(thisRow, this.valueList, this.typeList);
            }
            this.valueList = new ArrayList<String>();
            this.typeList = new ArrayList<ExcelDataType>();
            this.lastColumnNumber = -1;
            this.notAllEmpty = false;
        }
    }

    private ExcelDataType getNumberType(String value) {
        String[] tmp = value.split("\\.");
        if (tmp.length == 1) {
            return ExcelDataType.INT;
        }
        return ExcelDataType.DOUBLE;
    }
}

