/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.constant;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.FileMagic;

public enum ExcelType {
    XLS(".xls"),
    XLSX(".xlsx");

    private String value;

    private ExcelType(String value) {
        this.setValue(value);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static ExcelType valueOf(InputStream inputStream) {
        try {
            if (!inputStream.markSupported()) {
                return null;
            }
            FileMagic fileMagic = FileMagic.valueOf((InputStream)inputStream);
            if (FileMagic.OLE2.equals((Object)fileMagic)) {
                return XLS;
            }
            return FileMagic.OOXML.equals((Object)fileMagic) ? XLSX : null;
        }
        catch (IOException var2) {
            throw new RuntimeException(var2);
        }
    }

    public static ExcelType getType(String fileName) {
        try {
            String[] tmp = fileName.split("\\.");
            String suffix = tmp[tmp.length - 1];
            if ("xls".equalsIgnoreCase(suffix)) {
                return XLS;
            }
            if ("xlsx".equalsIgnoreCase(suffix)) {
                return XLSX;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

