/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.dbService;

import com.tydic.common.dbService.DatabaseService;
import com.tydic.common.dbService.DbColumn;
import com.tydic.common.dbService.SQLBuild;
import com.tydic.common.dbService.SQLExecutor;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDatabaseService
implements DatabaseService {
    protected SQLExecutor executor;
    protected SQLBuild sqlBuild;

    @Override
    public boolean check(String tableName, List<DbColumn> columnList) throws Exception {
        if (!this.checkDatabase()) {
            return false;
        }
        if (!this.checkHasTable(tableName)) {
            return false;
        }
        return this.checkHasCol(tableName, columnList).isEmpty();
    }

    @Override
    public boolean checkDatabase() throws Exception {
        return this.executor.testConnection();
    }

    @Override
    public boolean checkHasTable(String tableName) throws Exception {
        String schema = this.executor.getSchema();
        String sql = "SELECT COUNT(*) as count FROM information_schema.`TABLES` WHERE TABLE_SCHEMA='" + schema + "' AND TABLE_NAME='" + tableName.toLowerCase() + "'";
        ArrayList<String> colList = new ArrayList<String>();
        colList.add("count");
        Map<String, String> result = this.executor.queryForOne(sql, colList);
        return result.containsKey("count") && Integer.valueOf(result.get("count")) > 0;
    }

    @Override
    public Map<String, Object> checkHasCol(String tableName, List<DbColumn> columnList) throws Exception {
        List moreList;
        HashMap<String, Object> checkMap = new HashMap<String, Object>();
        List<DbColumn> hasColList = this.selectCol(this.executor.getSchema(), tableName);
        ArrayList<DbColumn> notHasList = new ArrayList<DbColumn>();
        for (DbColumn item2 : hasColList) {
            boolean has = false;
            for (DbColumn a : columnList) {
                if (!item2.getName().equals(a.getName()) || !this.compareType(a.getType(), item2.getType())) continue;
                has = true;
                a.setOrder(item2.getOrder());
                break;
            }
            if (has) continue;
            notHasList.add(item2);
        }
        if (!notHasList.isEmpty()) {
            checkMap.put("lost", notHasList);
        }
        if (!(moreList = columnList.stream().filter(item -> hasColList.stream().filter(hasItem -> hasItem.getName().equals(item.getName()) && this.compareType(item.getType(), hasItem.getType())).collect(Collectors.toList()).isEmpty()).collect(Collectors.toList())).isEmpty()) {
            checkMap.put("more", moreList);
        }
        return checkMap;
    }

    @Override
    public void createTable(String tableName, List<DbColumn> colList) throws Exception {
        this.checkInit();
        String sql = this.sqlBuild.genCreateTable(tableName, colList, tableName);
        this.executor.execute(sql);
    }

    @Override
    public void insert(String tableName, List<String> colList, List<String> data) throws Exception {
    }

    @Override
    public void insertAll(String tableName, List<String> colList, List<List<String>> data) throws Exception {
        this.checkInit();
        String sql = this.sqlBuild.genInsertAll(tableName, colList, data);
        this.executor.execute(sql);
    }

    @Override
    public void insertAllByFile(String tableName, List<String> colList, List<List<String>> data) throws Exception {
        String filePath = null;
        try {
            filePath = this.writeToFile(tableName, colList, data);
            this.loadFile(tableName, filePath);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            File file;
            if (StringUtils.isNotBlank(filePath) && (file = new File(filePath)).exists()) {
                file.delete();
            }
        }
    }

    @Override
    public void delete(String tableName) throws Exception {
        this.checkInit();
        String sql = this.sqlBuild.genDelete(tableName);
        this.executor.execute(sql);
    }

    @Override
    public void delete(String tableName, List<String> colList, List<String> data) throws Exception {
    }

    @Override
    public List selectAll(String tableName, List<String> colList, List<String> data) throws Exception {
        return null;
    }

    @Override
    public List<DbColumn> selectCol(String scheme, String tableName) throws Exception {
        this.checkInit();
        String sql = this.sqlBuild.genSelectCol(scheme, tableName);
        ArrayList<String> colList = new ArrayList<String>();
        colList.add("COLUMN_NAME");
        colList.add("COLUMN_TYPE");
        List<Map<String, String>> result = this.executor.query(sql, colList);
        ArrayList<DbColumn> columnList = new ArrayList<DbColumn>();
        for (int i = 0; i < result.size(); ++i) {
            Map<String, String> row = result.get(i);
            DbColumn column = new DbColumn();
            column.setName(row.get("COLUMN_NAME"));
            column.setType(row.get("COLUMN_TYPE"));
            column.setOrder(i);
            columnList.add(column);
        }
        return columnList;
    }

    @Override
    public void addCol(String tableName, List<DbColumn> colList) throws Exception {
    }

    @Override
    public void removeCol(String tableName, List<String> colList) throws Exception {
    }

    @Override
    public void loadFile(String tableName, String filePath) throws Exception {
        this.checkInit();
        String sql = this.sqlBuild.genLoadFile(tableName, filePath);
        try (FileInputStream fis = new FileInputStream(filePath);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            this.executor.loadFile(sql, bis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkInit() throws Exception {
        if (null == this.sqlBuild || null == this.executor) {
            throw new Exception("sqlBuild or executor has not init!please check code!");
        }
    }

    protected String writeToFile(String tableName, List<String> colList, List<List<String>> data) throws Exception {
        int index = 0;
        String suffix = ".csv";
        String filePath = "./" + tableName;
        File file = new File(filePath + index + suffix);
        while (file.exists()) {
            file = new File(filePath + ++index + suffix);
        }
        filePath = filePath + index + suffix;
        try (FileWriter fos = new FileWriter(file);
             BufferedWriter writer = new BufferedWriter(fos);){
            for (List<String> row : data) {
                for (int i = 0; i < row.size(); ++i) {
                    if (!StringUtils.isBlank((CharSequence)row.get(i))) continue;
                    row.set(i, null);
                }
                if (null == row || row.isEmpty()) continue;
                String str = StringUtils.join(row, (String)",");
                writer.write(str);
                writer.newLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filePath;
    }

    public abstract boolean compareType(String var1, String var2);
}

