/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.dbService;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;

public class DbDataSource
implements DataSource {
    private String ip;
    private String port;
    private String user;
    private String passwd;
    private String dbName;
    private String url;
    private String dbType;

    @Override
    public Connection getConnection() throws SQLException {
        if (StringUtils.isBlank((CharSequence)this.url)) {
            this.url = this.createUrl();
        }
        this.loadDriver();
        Connection connection = DriverManager.getConnection(this.url, this.user, this.passwd);
        return connection;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (StringUtils.isBlank((CharSequence)this.url)) {
            this.url = this.createUrl();
        }
        this.loadDriver();
        Connection connection = DriverManager.getConnection(this.url, username, password);
        return connection;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public String createUrl() {
        String sql = null;
        switch (this.dbType) {
            case "mysql": {
                sql = this.createMysqlUrl();
            }
        }
        return sql;
    }

    private String createMysqlUrl() {
        String url = "jdbc:mysql://" + this.ip + ":" + this.port + "/" + this.dbName + "?characterEncoding=utf-8&useUnicode=true&useOldAliasMetadataBehavior=true&autoReconnect=true&zeroDateTimeBehavior=convertToNull";
        return url;
    }

    private void loadDriver() {
        String driverName = null;
        switch (this.dbType) {
            case "mysql": {
                driverName = "com.mysql.jdbc.Driver";
                break;
            }
            case "h2": {
                driverName = "org.h2.Driver";
            }
        }
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }
}

