/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.dbService;

import com.tydic.common.dbService.DbDataSource;
import com.tydic.common.dbService.SQLExecutor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DefaultExecutor
implements SQLExecutor {
    private DbDataSource dataSource;

    public DefaultExecutor(DbDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void setDataSource(DbDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DbDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void setDataSource(Map<String, String> dbParamMap) {
        this.dataSource = new DbDataSource();
        this.dataSource.setDbType(dbParamMap.get("DbType"));
        this.dataSource.setIp(dbParamMap.get("Ip"));
        this.dataSource.setPort(dbParamMap.get("DbType"));
        this.dataSource.setUser(dbParamMap.get("user"));
        this.dataSource.setPasswd(dbParamMap.get("passwd"));
        this.dataSource.setDbName(dbParamMap.get("dbName"));
        this.dataSource.setUrl(dbParamMap.get("url"));
    }

    @Override
    public boolean testConnection() {
        if (null == this.dataSource) {
            return false;
        }
        boolean flag = false;
        try (Connection connection = this.dataSource.getConnection();){
            if (null != connection) {
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Override
    public String getSchema() {
        if (null == this.dataSource) {
            return null;
        }
        return this.dataSource.getDbName();
    }

    @Override
    public void execute(String sql) throws Exception {
        System.out.println("\u51c6\u5907\u5f00\u59cb\u6267\u884cSQL\uff1a" + sql);
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (Exception e) {
            throw new Exception("\u6267\u884csql\u8bed\u53e5\u5f02\u5e38\uff0csql:" + sql, e);
        }
    }

    @Override
    public List<Map<String, String>> query(String sql, List<String> colList) throws Exception {
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                for (String col : colList) {
                    String value = resultSet.getString(col);
                    dataMap.put(col, value);
                }
                data.add(dataMap);
            }
        }
        catch (Exception e) {
            throw new Exception("\u67e5\u8be2\u7ed3\u679c\u6570\u636e\u5931\u8d25 sql:" + sql, e);
        }
        return data;
    }

    @Override
    public Map<String, String> queryForOne(String sql, List<String> colList) throws Exception {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(sql);
            if (resultSet.next()) {
                for (String col : colList) {
                    String value = resultSet.getString(col);
                    dataMap.put(col, value);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("\u67e5\u8be2\u7ed3\u679c\u6570\u636e\u5931\u8d25 sql:" + sql, e);
        }
        return dataMap;
    }
}

