/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.dbService.factory;

import com.tydic.common.dbService.DatabaseService;
import com.tydic.common.dbService.DbDataSource;
import com.tydic.common.dbService.h2.H2DatabaseService;
import com.tydic.common.dbService.mysql.MysqlDatabaseService;

public class DatabaseServiceFactory {
    public static DatabaseService createDatabaseService(DbDataSource dataSource) {
        if ("mysql".equals(dataSource.getDbType())) {
            return new MysqlDatabaseService(dataSource);
        }
        switch (dataSource.getDbType()) {
            case "mysql": {
                return new MysqlDatabaseService(dataSource);
            }
            case "h2": {
                return new H2DatabaseService(dataSource);
            }
        }
        return null;
    }
}

