/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.dbService.h2;

import com.tydic.common.dbService.AbstractDatabaseService;
import com.tydic.common.dbService.DbDataSource;
import com.tydic.common.dbService.h2.H2Build;
import com.tydic.common.dbService.h2.H2Executor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class H2DatabaseService
extends AbstractDatabaseService {
    public H2DatabaseService(DbDataSource dataSource) {
        this.executor = new H2Executor(dataSource);
        this.sqlBuild = new H2Build();
    }

    @Override
    public void loadFile(String tableName, String filePath) throws Exception {
        this.checkInit();
        String sql = this.sqlBuild.genLoadFile(tableName, filePath);
        this.executor.execute(sql);
    }

    @Override
    public boolean compareType(String typeConstants, String sqlType) {
        switch (typeConstants) {
            case "int(20)": {
                return sqlType.equals("integer");
            }
            case "numeric(37, 4)": {
                return sqlType.startsWith("decimal");
            }
            case "varchar(200)": {
                return sqlType.startsWith("varchar");
            }
            case "date": {
                return sqlType.equals("date");
            }
            case "time": {
                return sqlType.equals("time");
            }
            case "datetime": {
                return sqlType.equals("timestamp");
            }
        }
        return false;
    }

    @Override
    protected String writeToFile(String tableName, List<String> colList, List<List<String>> data) throws Exception {
        int index = 0;
        String suffix = ".csv";
        String filePath = "./" + tableName;
        File file = new File(filePath + index + suffix);
        while (file.exists()) {
            file = new File(filePath + ++index + suffix);
        }
        filePath = filePath + index + suffix;
        try (FileWriter fos = new FileWriter(file);
             BufferedWriter writer = new BufferedWriter(fos);){
            String title = StringUtils.join(colList, (String)",");
            writer.write(title);
            writer.newLine();
            for (List<String> row : data) {
                for (int i = 0; i < row.size(); ++i) {
                    if (!StringUtils.isBlank((CharSequence)row.get(i))) continue;
                    row.set(i, null);
                }
                if (null == row || row.isEmpty()) continue;
                String str = StringUtils.join(row, (String)",");
                writer.write(str);
                writer.newLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filePath;
    }
}

