/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.dbService.mysql;

import com.tydic.common.dbService.DbColumn;
import com.tydic.common.dbService.SQLBuild;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MySQlBuild
implements SQLBuild {
    @Override
    public String genCreateTable(String tableName, List<DbColumn> colList, String tableComment) {
        StringBuilder sqlBuild = new StringBuilder();
        StringBuilder pkSqlBuild = new StringBuilder();
        StringBuilder indexSqlBuild = new StringBuilder();
        sqlBuild.append("CREATE TABLE IF NOT EXISTS  `").append(tableName).append("` (");
        for (DbColumn column : colList) {
            String colName = column.getName();
            String type = column.getType();
            sqlBuild.append("`").append(colName).append("` ").append(type);
            if (StringUtils.isNotBlank((CharSequence)column.getCommit())) {
                sqlBuild.append(" COMMENT '").append(column.getCommit()).append("'");
            }
            sqlBuild.append(",");
            if (column.isPK().booleanValue()) {
                pkSqlBuild.append("`").append(colName).append("` ").append(",");
            }
            if (!column.isIndex().booleanValue()) continue;
            indexSqlBuild.append(" KEY `").append("index_").append(colName).append("`").append("(").append(colName).append(")");
            indexSqlBuild.append(",");
        }
        if (pkSqlBuild.length() > 0) {
            pkSqlBuild.deleteCharAt(pkSqlBuild.length() - 1);
            sqlBuild.append("PRIMARY KEY ( ").append(pkSqlBuild.toString()).append("),");
        }
        if (indexSqlBuild.length() > 0) {
            sqlBuild.append(indexSqlBuild.toString());
        }
        sqlBuild.deleteCharAt(sqlBuild.length() - 1);
        sqlBuild.append(")");
        if (StringUtils.isNotBlank((CharSequence)tableComment)) {
            sqlBuild.append(" COMMENT='" + tableComment + "'");
        }
        return sqlBuild.toString();
    }

    @Override
    public String genInsert(String tableName, List<String> colList, List<String> data) {
        return null;
    }

    @Override
    public String genInsertAll(String tableName, List<String> colList, List<List<String>> data) {
        StringBuilder sqlBuild = new StringBuilder();
        sqlBuild.append("REPLACE INTO `").append(tableName).append("`");
        sqlBuild.append("(");
        for (String string : colList) {
            sqlBuild.append("`").append(string).append("`,");
        }
        sqlBuild.deleteCharAt(sqlBuild.length() - 1);
        sqlBuild.append(") values ");
        if (null == data || data.isEmpty()) {
            return null;
        }
        for (List list : data) {
            sqlBuild.append("(");
            for (String value : list) {
                if (StringUtils.isBlank((CharSequence)value)) {
                    sqlBuild.append("null,");
                    continue;
                }
                sqlBuild.append("'").append(value).append("',");
            }
            sqlBuild.deleteCharAt(sqlBuild.length() - 1);
            sqlBuild.append(") ,");
        }
        sqlBuild.deleteCharAt(sqlBuild.length() - 1);
        return sqlBuild.toString();
    }

    @Override
    public String genDelete(String tableName) {
        return "DELETE FROM " + tableName;
    }

    @Override
    public String genDelete(String tableName, List<String> colList, List<String> data) {
        return null;
    }

    @Override
    public String genSelectAll(String tableName, List<String> colList, List<String> data) {
        return null;
    }

    @Override
    public String genSelectCol(String scheme, String tableName) {
        StringBuilder sqlBuild = new StringBuilder();
        sqlBuild.append("SELECT COLUMN_NAME,COLUMN_TYPE FROM information_schema.`COLUMNS` where TABLE_SCHEMA='").append(scheme).append("' AND TABLE_NAME = '").append(tableName).append("'");
        return sqlBuild.toString();
    }

    @Override
    public String genAddCol(String tableName, List<DbColumn> colList) {
        return null;
    }

    @Override
    public String genRemoveCol(String tableName, List<String> colList) {
        return null;
    }

    @Override
    public String genLoadFile(String tableName, String fileName) {
        StringBuilder sql = new StringBuilder();
        sql.append("load data local infile '").append(fileName).append("'").append(" REPLACE INTO TABLE `").append(tableName).append("`").append(" fields terminated by ',' ").append(" lines terminated by '\\r\\n'");
        return sql.toString();
    }
}

