/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.handle;

import com.tydic.common.constant.Constants;
import com.tydic.common.constant.ExcelDataType;
import com.tydic.common.constant.ExcelType;
import com.tydic.common.constant.SQLConstants;
import com.tydic.common.dbService.DatabaseService;
import com.tydic.common.dbService.DbColumn;
import com.tydic.common.handle.AbstractSheetContentsHandler;
import com.tydic.common.model.ExcelColumn;
import com.tydic.common.utils.ParseUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFComment;

public class AnalysisContentsHandler
extends AbstractSheetContentsHandler {
    private DatabaseService databaseService;
    private List<Map> paramList;
    private int count = 0;
    private int nowSheetIndex;
    private List<List<String>> tmpData;
    private ExcelType type;

    public AnalysisContentsHandler(DatabaseService databaseService, List<Map> paramList) {
        this.databaseService = databaseService;
        this.paramList = paramList;
        this.nowSheetIndex = 0;
        this.tmpData = new ArrayList<List<String>>();
    }

    @Override
    public void startRow(int rowNum) {
    }

    @Override
    public void endRow(int rowNum, List<String> valueList, List<ExcelDataType> typeList) {
        if (0 == rowNum) {
            return;
        }
        int sheetIndex = this.getSheetIndex();
        this.type = this.getExcelType();
        if (this.nowSheetIndex != sheetIndex) {
            this.insertData();
            this.nowSheetIndex = sheetIndex;
        }
        this.tmpData.add(valueList);
        if (this.tmpData.size() >= 10000) {
            this.insertData();
        }
    }

    @Override
    public void cell(String cellReference, String formattedValue, ExcelDataType type, XSSFComment comment) {
    }

    @Override
    public void headerFooter(String text, boolean isHeader, String tagName) {
    }

    @Override
    public void endAllAnalysis() {
        if (!this.tmpData.isEmpty()) {
            this.insertData();
        }
    }

    private void insertData() {
        System.out.println(this.count);
        ++this.count;
        Map param = this.paramList.get(this.nowSheetIndex);
        String tableName = (String)param.get("tableName");
        List columnList = (List)this.paramList.get(this.sheetIndex).get("columnList");
        columnList.sort((o1, o2) -> o1.getOrder().compareTo(o2.getOrder()));
        ArrayList<String> colList = new ArrayList<String>();
        for (Object column : columnList) {
            colList.add(((DbColumn)column).getName());
        }
        ArrayList<List<String>> valueSet = new ArrayList<List<String>>();
        for (List list : this.tmpData) {
            ArrayList<String> valueRow = new ArrayList<String>();
            for (int i = 0; i < columnList.size(); ++i) {
                String value = null;
                int order = ((ExcelColumn)columnList.get(i)).getExcelOrder();
                if (order >= list.size()) continue;
                value = (String)list.get(order);
                valueRow.add(value);
            }
            valueSet.add(valueRow);
        }
        try {
            this.databaseService.insertAllByFile(tableName, colList, valueSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tmpData = new ArrayList<List<String>>();
    }

    private String parseValue(Object value, String type) {
        if (ExcelType.XLS.equals((Object)this.type)) {
            return this.parseValueForXls(value, type);
        }
        if (ExcelType.XLSX.equals((Object)this.type)) {
            return this.parseValueForXlsX(value, type);
        }
        return this.parseValueForXlsX(value, type);
    }

    private String parseValueForXls(Object value, String type) {
        if (null == value) {
            return SQLConstants.COL_VALUE_BLANK;
        }
        String valueStr = (String)value;
        if (type.startsWith("int")) {
            valueStr = String.valueOf(ParseUtils.parseInt(valueStr));
        }
        if (type.equals("date")) {
            Date date = new Date(valueStr);
            valueStr = Constants.DATE_FORMAT_DATE.format(date);
        }
        return valueStr;
    }

    private String parseValueForXlsX(Object value, String type) {
        Calendar calendar;
        if (null == value) {
            return SQLConstants.COL_VALUE_BLANK;
        }
        String valueStr = (String)value;
        if (type.startsWith("int")) {
            valueStr = String.valueOf(ParseUtils.parseInt(valueStr));
        }
        if (type.equals("time")) {
            calendar = DateUtil.getJavaCalendar((double)Double.valueOf(valueStr));
            valueStr = Constants.DATE_FORMAT_TIME.format(calendar.getTime());
        }
        if (type.equals("date")) {
            calendar = DateUtil.getJavaCalendar((double)Double.valueOf(valueStr));
            valueStr = Constants.DATE_FORMAT_DATE.format(calendar.getTime());
        }
        if (type.equals("datetime")) {
            calendar = DateUtil.getJavaCalendar((double)Double.valueOf(valueStr));
            valueStr = Constants.DATE_FORMAT_DATETIME.format(calendar.getTime());
        }
        return valueStr;
    }
}

