/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.handle;

import com.tydic.common.constant.ExcelDataType;
import com.tydic.common.handle.AbstractSheetContentsHandler;
import com.tydic.common.model.ExcelColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFComment;

public class CheckContentsHandler
extends AbstractSheetContentsHandler {
    private List<List<String>> nameList = new ArrayList<List<String>>();
    private List<List<ExcelDataType>> typeList = new ArrayList<List<ExcelDataType>>();
    private List<String> sheetNameList = new ArrayList<String>();

    @Override
    public void startRow(int rowNum) {
    }

    @Override
    public void endRow(int rowNum, List<String> valueList, List<ExcelDataType> typeList) {
        if (rowNum == 0) {
            this.updateNameList(valueList);
        } else {
            this.updateTypeList(typeList);
        }
    }

    @Override
    public void cell(String cellReference, String formattedValue, ExcelDataType type, XSSFComment comment) {
    }

    @Override
    public void headerFooter(String text, boolean isHeader, String tagName) {
    }

    @Override
    public void endAllAnalysis() {
    }

    private void updateNameList(List<String> nameList) {
        if (this.getSheetIndex() < this.nameList.size()) {
            this.nameList.set(this.getSheetIndex(), nameList);
            this.sheetNameList.set(this.getSheetIndex(), this.getSheetName());
        } else {
            for (int i = 1; i < this.getSheetIndex() - this.nameList.size(); ++i) {
                this.nameList.add(null);
                this.sheetNameList.add("sheet-" + this.getSheetIndex());
            }
            this.nameList.add(nameList);
            this.sheetNameList.add(this.getSheetName());
        }
    }

    private void updateTypeList(List<ExcelDataType> typeList) {
        List<ExcelDataType> nowTypeList = null;
        if (this.getSheetIndex() >= this.typeList.size()) {
            nowTypeList = new ArrayList<ExcelDataType>(typeList);
            for (int i = 1; i < this.getSheetIndex() - this.typeList.size(); ++i) {
                this.typeList.add(null);
            }
            this.typeList.add(nowTypeList);
            return;
        }
        nowTypeList = this.typeList.get(this.getSheetIndex());
        List<String> nameList = this.nameList.get(this.getSheetIndex());
        for (int i = 0; i < nameList.size(); ++i) {
            if (i >= typeList.size()) continue;
            if (ExcelDataType.INT.equals((Object)nowTypeList.get(i)) && ExcelDataType.DOUBLE.equals((Object)typeList.get(i))) {
                nowTypeList.set(i, typeList.get(i));
            }
            if (!ExcelDataType.STRING.equals((Object)typeList.get(i))) continue;
            nowTypeList.set(i, typeList.get(i));
        }
    }

    public Map<String, Object> getCheckMap(int sheetIndex) {
        HashMap<String, Object> sheetMap = new HashMap<String, Object>();
        ArrayList<ExcelColumn> columnList = new ArrayList<ExcelColumn>();
        List<String> nameList = this.nameList.get(sheetIndex);
        List<ExcelDataType> typeList = this.typeList.get(sheetIndex);
        for (int i = 0; i < nameList.size(); ++i) {
            if (StringUtils.isBlank((CharSequence)nameList.get(i))) continue;
            ExcelColumn column = new ExcelColumn();
            column.setColumnName(nameList.get(i));
            column.setCommit(nameList.get(i));
            column.setOrder(i);
            column.setExcelOrder(i);
            column.setName(nameList.get(i));
            column.setType(this.getType(typeList.get(i)));
            columnList.add(column);
        }
        sheetMap.put("tableName", this.sheetNameList.get(sheetIndex));
        sheetMap.put("SheetName", this.sheetNameList.get(sheetIndex));
        sheetMap.put("createTable", true);
        sheetMap.put("clearTable", false);
        sheetMap.put("columnList", columnList);
        return sheetMap;
    }

    public List<Map> getCheckMapList() {
        ArrayList<Map> checkMapList = new ArrayList<Map>();
        for (int i = 0; i < this.nameList.size(); ++i) {
            Map<String, Object> checkMap = this.getCheckMap(i);
            checkMapList.add(checkMap);
        }
        return checkMapList;
    }

    private String getType(ExcelDataType typeEnum) {
        switch (typeEnum) {
            case STRING: {
                return "varchar(200)";
            }
            case INT: {
                return "int(20)";
            }
            case DOUBLE: {
                return "numeric(37, 4)";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case DATETIME: {
                return "datetime";
            }
        }
        return "varchar(200)";
    }
}

