/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.model;

import org.apache.poi.ss.util.CellRangeAddress;

public class RectCell {
    private int firstRow;
    private int firstCol;
    private int lastRow;
    private int lastCol;

    public RectCell() {
    }

    public RectCell(int firstRow, int firstCol, int lastRow, int lastCol) {
        this.firstRow = firstRow;
        this.firstCol = firstCol;
        this.lastRow = lastRow;
        this.lastCol = lastCol;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public int getFirstCol() {
        return this.firstCol;
    }

    public void setFirstCol(int firstCol) {
        this.firstCol = firstCol;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public void setLastRow(int lastRow) {
        this.lastRow = lastRow;
    }

    public int getLastCol() {
        return this.lastCol;
    }

    public void setLastCol(int lastCol) {
        this.lastCol = lastCol;
    }

    public String formatAsString(String sheetName, boolean useAbsoluteAddress) {
        return new CellRangeAddress(this.firstRow, this.lastRow, this.firstCol, this.lastCol).formatAsString(sheetName, useAbsoluteAddress);
    }

    public int contains(int row, int col) {
        if (row >= this.firstRow && row <= this.lastRow && col >= this.firstCol && col <= this.lastCol) {
            return (row - this.firstRow) * (row - this.firstRow) + (col - this.firstCol) * (col - this.firstCol);
        }
        return -1;
    }

    public RectCell clone() {
        return new RectCell(this.firstRow, this.firstCol, this.lastRow, this.lastCol);
    }
}

