/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.model;

import com.tydic.common.constant.DefaultStyleValue;
import com.tydic.common.constant.StyleName;
import com.tydic.common.model.ChartInfo;
import com.tydic.common.model.RectCell;
import com.tydic.common.model.SlantLine;
import com.tydic.common.model.StyleData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SheetData
implements Cloneable {
    private String sheetName;
    private int headerRow;
    private int colWidths = 100;
    private int rowHeights = 100;
    private List<List<Object>> data;
    private Map<String, StyleData> styleMap;
    private Map<String, String> defaultStyleMap;
    private List<RectCell> mergeCellList;
    private List<SlantLine> slantLineList;
    private List<ChartInfo> chartInfoList;
    private RectCell freezePanel;
    private int rowCount = 0;
    private int colCount = 0;

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public int getColWidths() {
        return this.colWidths;
    }

    public void setColWidths(int colWidths) {
        this.colWidths = colWidths;
    }

    public int getRowHeights() {
        return this.rowHeights;
    }

    public void setRowHeights(int rowHeights) {
        this.rowHeights = rowHeights;
    }

    public List<List<Object>> getData() {
        return this.data;
    }

    public void setData(List<List<Object>> data) {
        this.data = data;
    }

    public Map<String, StyleData> getStyleMap() {
        return this.styleMap;
    }

    public void setStyleMap(Map<String, StyleData> styleMap) {
        this.styleMap = styleMap;
    }

    public Map<String, String> getDefaultStyleMap() {
        return this.defaultStyleMap;
    }

    public void setDefaultStyleMap(Map<String, String> defaultStyleMap) {
        this.defaultStyleMap = defaultStyleMap;
    }

    public List<RectCell> getMergeCellList() {
        return this.mergeCellList;
    }

    public void setMergeCellList(List<RectCell> mergeCellList) {
        this.mergeCellList = mergeCellList;
        for (RectCell cell : mergeCellList) {
            this.updateByCell(cell);
        }
    }

    public List<SlantLine> getSlantLineList() {
        return this.slantLineList;
    }

    public void setSlantLineList(List<SlantLine> slantLineList) {
        this.slantLineList = slantLineList;
        for (SlantLine slantLine : slantLineList) {
            this.updateByCell(slantLine.getCell());
        }
    }

    public int getHeaderRow() {
        return this.headerRow;
    }

    public void setHeaderRow(int headerRow) {
        this.headerRow = headerRow;
    }

    public List<ChartInfo> getChartInfoList() {
        return this.chartInfoList;
    }

    public void setChartInfoList(List<ChartInfo> chartInfoList) {
        this.chartInfoList = chartInfoList;
    }

    public RectCell getFreezePanel() {
        return this.freezePanel;
    }

    public void setFreezePanel(RectCell freezePanel) {
        this.freezePanel = freezePanel;
        this.updateByCell(freezePanel);
    }

    private void updateByCell(RectCell cell) {
        int row = cell.getLastRow();
        int col = cell.getLastCol();
        this.rowCount = row + 1 > this.rowCount ? row + 1 : this.rowCount;
        this.colCount = col + 1 > this.colCount ? col + 1 : this.colCount;
    }

    public int getRowCount() {
        int n = this.rowCount = this.data.size() > this.rowCount ? this.data.size() : this.rowCount;
        if (null == this.styleMap) {
            return this.rowCount;
        }
        for (StyleData styleData : this.styleMap.values()) {
            this.rowCount = styleData.getRowCount() > this.rowCount ? styleData.getRowCount() : this.rowCount;
        }
        return this.rowCount;
    }

    public int getColCount() {
        this.data.forEach(row -> {
            if (null != row) {
                this.colCount = row.size() > this.colCount ? row.size() : this.colCount;
            }
        });
        if (null == this.styleMap) {
            return this.colCount;
        }
        for (StyleData styleData : this.styleMap.values()) {
            this.colCount = styleData.getColCount() > this.colCount ? styleData.getColCount() : this.colCount;
        }
        return this.colCount;
    }

    public int getColCount(int rowIndex) {
        int count = 0;
        if (this.data.size() > rowIndex && null != this.data.get(rowIndex)) {
            count = this.data.get(rowIndex).size();
        }
        if (null == this.styleMap) {
            return count;
        }
        for (StyleData styleData : this.styleMap.values()) {
            count = styleData.getColCount() > count ? styleData.getColCount() : count;
        }
        return count;
    }

    public Object getValue(int row, int col) {
        List<Object> rowList;
        if (row < 0 || col < 0) {
            return null;
        }
        Object value = null;
        if (this.data.size() > row && (rowList = this.data.get(row)).size() > col) {
            value = rowList.get(col);
        }
        return value;
    }

    public StyleData getStyleData(String name) {
        StyleData styleData;
        if (null == this.styleMap) {
            this.styleMap = new HashMap<String, StyleData>();
        }
        if (null == (styleData = this.styleMap.get(name))) {
            styleData = new StyleData(name);
            this.styleMap.put(name, styleData);
        }
        return styleData;
    }

    public String getStyleValue(String name, int row, int col) {
        String tmpValue;
        if (row < 0 || col < 0) {
            return null;
        }
        String value = null;
        if (null == this.defaultStyleMap) {
            this.defaultStyleMap = DefaultStyleValue.DEFAULT_STYLE_MAP;
        }
        value = this.defaultStyleMap.get(name);
        if (null != this.styleMap && this.styleMap.containsKey(name) && StringUtils.isNotBlank((CharSequence)(tmpValue = this.styleMap.get(name).get(row, col)))) {
            value = tmpValue;
        }
        return value;
    }

    public Map<String, String> getStyleMap(int row, int col) {
        HashMap<String, String> cellStyleMap = new HashMap<String, String>();
        for (String styleName : StyleName.KEY_ORDER) {
            String value = this.getStyleValue(styleName, row, col);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            cellStyleMap.put(styleName, value);
        }
        return cellStyleMap;
    }

    public String getStyleKey(int row, int col) {
        StringBuilder key = new StringBuilder();
        for (String styleName : StyleName.KEY_ORDER) {
            String value = this.getStyleValue(styleName, row, col);
            key.append(value).append("-");
        }
        key.deleteCharAt(key.length() - 1);
        return key.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

