/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.model;

import com.tydic.common.model.RectCell;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;

public class StyleData {
    private String styleName;
    private LinkedHashMap<RectCell, String> valueMap = new LinkedHashMap();
    private int rowCount;
    private int colCount;

    public StyleData() {
    }

    public StyleData(String styleName) {
        this();
        this.styleName = styleName;
    }

    public void add(int row, int col, String value) {
        this.add(row, col, row, col, value);
    }

    public void add(int firstRow, int firstCol, int lastRow, int lastCol, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        RectCell cell = new RectCell(firstRow, firstCol, lastRow, lastCol);
        this.valueMap.put(cell, value);
        this.rowCount = lastRow + 1 > this.rowCount ? lastRow + 1 : this.rowCount;
        this.colCount = lastCol + 1 > this.colCount ? lastCol + 1 : this.colCount;
    }

    public String get(int row, int col) {
        if (row < 0 || row >= this.rowCount || col < 0 || col >= this.colCount) {
            return null;
        }
        String value = null;
        for (RectCell key : this.valueMap.keySet()) {
            int tmp = key.contains(row, col);
            if (tmp <= -1) continue;
            value = this.valueMap.get(key);
        }
        return value;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColCount() {
        return this.colCount;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }
}

