/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.reader;

import com.tydic.common.analysis.v03.BaseHSSFListener;
import com.tydic.common.analysis.v07.BaseXSSFXMLHandler;
import com.tydic.common.constant.ExcelType;
import com.tydic.common.handle.SheetContentsHandler;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.util.SAXHelper;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.StylesTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ExcelSAXReader {
    private static final Logger log = LoggerFactory.getLogger(ExcelSAXReader.class);

    public static void read(String path, SheetContentsHandler handle) throws Exception {
        ExcelType type = ExcelType.getType(path);
        if (null == type) {
            log.error("\u6587\u4ef6\u7c7b\u578b\u65e0\u6cd5\u63a8\u65ad");
            return;
        }
        if (ExcelType.XLSX.equals((Object)type)) {
            ExcelSAXReader.readXlsx(path, handle);
        } else if (ExcelType.XLS.equals((Object)type)) {
            ExcelSAXReader.readXls(path, handle);
        }
    }

    public static void read(InputStream in, SheetContentsHandler handle) throws Exception {
        ExcelType type = ExcelType.valueOf(in);
        if (null == type) {
            log.error("\u6587\u4ef6\u7c7b\u578b\u65e0\u6cd5\u63a8\u65ad");
            return;
        }
        if (ExcelType.XLSX.equals((Object)type)) {
            ExcelSAXReader.readXlsx(in, handle);
        } else if (ExcelType.XLS.equals((Object)type)) {
            ExcelSAXReader.readXls(in, handle);
        }
    }

    public static void readXlsx(String path, SheetContentsHandler handle) {
        try (FileInputStream fis = new FileInputStream(path);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            ExcelSAXReader.readXlsx(bis, handle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void readXlsx(InputStream in, SheetContentsHandler handle) {
        try (OPCPackage pkg = OPCPackage.open((InputStream)in);){
            XSSFReader xssfReader = new XSSFReader(pkg);
            StylesTable styles = xssfReader.getStylesTable();
            ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(pkg);
            XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            int sheetIndex = 0;
            while (iter.hasNext()) {
                try {
                    InputStream stream = iter.next();
                    Throwable throwable = null;
                    try {
                        String sheetName = iter.getSheetName();
                        handle.setSheetName(sheetName);
                        handle.setSheetIndex(sheetIndex);
                        ++sheetIndex;
                        DataFormatter formatter = new DataFormatter();
                        InputSource sheetSource = new InputSource(stream);
                        try {
                            XMLReader sheetParser = SAXHelper.newXMLReader();
                            BaseXSSFXMLHandler handler = new BaseXSSFXMLHandler(styles, null, strings, handle, formatter, false);
                            sheetParser.setContentHandler(handler);
                            sheetParser.parse(sheetSource);
                            handle.endAllAnalysis();
                        }
                        catch (ParserConfigurationException e) {
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void readXls(String path, SheetContentsHandler handle) {
        try (FileInputStream fis = new FileInputStream(path);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            ExcelSAXReader.readXls(bis, handle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void readXls(InputStream in, SheetContentsHandler handle) throws Exception {
        HSSFRequest hssfRequest = new HSSFRequest();
        BaseHSSFListener listener = new BaseHSSFListener(handle);
        FormatTrackingHSSFListener formatListener = new FormatTrackingHSSFListener((HSSFListener)new MissingRecordAwareHSSFListener((HSSFListener)listener));
        listener.setFormatListener(formatListener);
        hssfRequest.addListenerForAllRecords((HSSFListener)formatListener);
        HSSFEventFactory factory = new HSSFEventFactory();
        POIFSFileSystem pfs = new POIFSFileSystem(in);
        factory.processWorkbookEvents(hssfRequest, pfs);
        handle.endAllAnalysis();
    }
}

