/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.service.impl;

import com.tydic.common.model.ChartInfo;
import com.tydic.common.model.RectCell;
import com.tydic.common.service.BuildChartService;
import com.tydic.common.utils.ParseUtils;
import java.util.List;
import org.apache.poi.ss.usermodel.Chart;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBoolean;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTCatAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDLbls;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLegend;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLineChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLineSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTMarker;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTMarkerStyle;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPieChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPieSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTScaling;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTValAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.STAxPos;
import org.openxmlformats.schemas.drawingml.x2006.chart.STBarDir;
import org.openxmlformats.schemas.drawingml.x2006.chart.STBarGrouping;
import org.openxmlformats.schemas.drawingml.x2006.chart.STCrossBetween;
import org.openxmlformats.schemas.drawingml.x2006.chart.STCrosses;
import org.openxmlformats.schemas.drawingml.x2006.chart.STGrouping;
import org.openxmlformats.schemas.drawingml.x2006.chart.STLblAlgn;
import org.openxmlformats.schemas.drawingml.x2006.chart.STLegendPos;
import org.openxmlformats.schemas.drawingml.x2006.chart.STMarkerStyle;
import org.openxmlformats.schemas.drawingml.x2006.chart.STOrientation;
import org.openxmlformats.schemas.drawingml.x2006.chart.STTickLblPos;
import org.openxmlformats.schemas.drawingml.x2006.chart.STTickMark;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;

public class BuildChartServiceImpl
implements BuildChartService {
    @Override
    public void buildBar(Chart chart, ChartInfo chartInfo, String sheetName) {
        CTChart ctChart = ((XSSFChart)chart).getCTChart();
        CTPlotArea ctPlotArea = ctChart.getPlotArea();
        CTBarChart ctBarChart = ctPlotArea.addNewBarChart();
        CTBoolean ctBoolean = ctBarChart.addNewVaryColors();
        ctBoolean.setVal(true);
        ctBarChart.addNewBarDir().setVal(STBarDir.COL);
        List<RectCell> seriesList = chartInfo.getSeries();
        RectCell classify = chartInfo.getClassify().clone();
        classify.setFirstRow(classify.getFirstRow() + 1);
        String classifyStrRef = classify.formatAsString(sheetName, true);
        for (int i = 0; i < seriesList.size(); ++i) {
            RectCell series = seriesList.get(i);
            CTBarSer ctBarSer = ctBarChart.addNewSer();
            CTSerTx ctSerTx = ctBarSer.addNewTx();
            CTStrRef ctStrRef = ctSerTx.addNewStrRef();
            String colIndex = ParseUtils.num2Char(series.getFirstCol());
            ctStrRef.setF("'" + sheetName + "'!$" + colIndex + "$" + (series.getFirstRow() + 1));
            ctBarSer.addNewIdx().setVal((long)i);
            CTAxDataSource cttAxDataSource = ctBarSer.addNewCat();
            ctStrRef = cttAxDataSource.addNewStrRef();
            ctStrRef.setF(classifyStrRef);
            CTNumDataSource ctNumDataSource = ctBarSer.addNewVal();
            CTNumRef ctNumRef = ctNumDataSource.addNewNumRef();
            ctNumRef.setF("'" + sheetName + "'!$" + colIndex + "$" + (series.getFirstRow() + 2) + ":$" + colIndex + "$" + (series.getLastRow() + 1));
            ctBarSer.addNewInvertIfNegative().setVal(false);
            ctBarSer.addNewSpPr().addNewLn().addNewSolidFill().addNewSrgbClr().setVal(new byte[]{0, 0, 0});
            if (!chartInfo.getShowLabel()) continue;
            ctBoolean.setVal(false);
            CTDLbls newDLbls = ctBarSer.addNewDLbls();
            newDLbls.setShowLegendKey(ctBoolean);
            ctBoolean.setVal(true);
            newDLbls.setShowVal(ctBoolean);
            ctBoolean.setVal(false);
            newDLbls.setShowCatName(ctBoolean);
            newDLbls.setShowSerName(ctBoolean);
            newDLbls.setShowPercent(ctBoolean);
            newDLbls.setShowBubbleSize(ctBoolean);
            newDLbls.setShowLeaderLines(ctBoolean);
        }
        ctBarChart.addNewAxId().setVal(123456L);
        ctBarChart.addNewAxId().setVal(123457L);
        CTCatAx ctCatAx = ctPlotArea.addNewCatAx();
        ctCatAx.addNewAxId().setVal(123456L);
        CTScaling ctScaling = ctCatAx.addNewScaling();
        ctScaling.addNewOrientation().setVal(STOrientation.MIN_MAX);
        ctCatAx.addNewDelete().setVal(false);
        ctCatAx.addNewAxPos().setVal(STAxPos.B);
        ctCatAx.addNewCrossAx().setVal(123457L);
        ctCatAx.addNewTickLblPos().setVal(STTickLblPos.NEXT_TO);
        CTValAx ctValAx = ctPlotArea.addNewValAx();
        ctValAx.addNewAxId().setVal(123457L);
        ctScaling = ctValAx.addNewScaling();
        ctScaling.addNewOrientation().setVal(STOrientation.MIN_MAX);
        ctValAx.addNewDelete().setVal(false);
        ctValAx.addNewAxPos().setVal(STAxPos.L);
        ctValAx.addNewCrossAx().setVal(123456L);
        ctValAx.addNewTickLblPos().setVal(STTickLblPos.NEXT_TO);
        if (chartInfo.getShowLegend()) {
            CTLegend ctLegend = ctChart.addNewLegend();
            ctLegend.addNewLegendPos().setVal(STLegendPos.B);
            ctLegend.addNewOverlay().setVal(false);
        }
    }

    @Override
    public void buildLine(Chart chart, ChartInfo chartInfo, String sheetName) {
        throw new UnsupportedOperationException("type line unSupport now");
    }

    @Override
    public void buildPie(Chart chart, ChartInfo chartInfo, String sheetName) {
        CTChart ctChart = ((XSSFChart)chart).getCTChart();
        CTPlotArea ctPlotArea = ctChart.getPlotArea();
        CTPieChart ctPieChart = ctPlotArea.addNewPieChart();
        CTBoolean ctBoolean = ctPieChart.addNewVaryColors();
        ctBoolean.setVal(true);
        List<RectCell> seriesList = chartInfo.getSeries();
        RectCell classify = chartInfo.getClassify().clone();
        classify.setFirstRow(classify.getFirstRow() + 1);
        String classifyStrRef = classify.formatAsString(sheetName, true);
        RectCell series = seriesList.get(0);
        CTPieSer ctPieSer = ctPieChart.addNewSer();
        CTSerTx ctSerTx = ctPieSer.addNewTx();
        CTStrRef ctStrRef = ctSerTx.addNewStrRef();
        String colIndex = ParseUtils.num2Char(series.getFirstCol());
        ctStrRef.setF("'" + sheetName + "'!$" + colIndex + "$" + (series.getFirstRow() + 1));
        ctPieSer.addNewIdx().setVal(0L);
        CTAxDataSource cttAxDataSource = ctPieSer.addNewCat();
        ctStrRef = cttAxDataSource.addNewStrRef();
        ctStrRef.setF(classifyStrRef);
        CTNumDataSource ctNumDataSource = ctPieSer.addNewVal();
        CTNumRef ctNumRef = ctNumDataSource.addNewNumRef();
        ctNumRef.setF("'" + sheetName + "'!$" + colIndex + "$" + (series.getFirstRow() + 2) + ":$" + colIndex + "$" + (series.getLastRow() + 1));
        ctPieSer.addNewSpPr().addNewLn().addNewSolidFill().addNewSrgbClr().setVal(new byte[]{0, 0, 0});
        ctPieChart.addNewFirstSliceAng().setVal(0);
        if (chartInfo.getShowLegend()) {
            CTLegend ctLegend = ctChart.addNewLegend();
            ctLegend.addNewLegendPos().setVal(STLegendPos.B);
            ctLegend.addNewOverlay().setVal(false);
        }
    }

    @Override
    public void buildBarLine(Chart chart, ChartInfo chartInfo, String sheetName) {
        CTChart ctChart = ((XSSFChart)chart).getCTChart();
        CTPlotArea ctPlotArea = ctChart.getPlotArea();
        CTBarChart ctBarChart = ctPlotArea.addNewBarChart();
        CTBoolean ctBoolean = ctBarChart.addNewVaryColors();
        ctBarChart.getVaryColors().setVal(true);
        ctBarChart.addNewGrouping().setVal(STBarGrouping.CLUSTERED);
        ctBoolean.setVal(true);
        ctBarChart.addNewBarDir().setVal(STBarDir.COL);
        CTTextBody rich = ctChart.addNewTitle().addNewTx().addNewRich();
        rich.addNewBodyPr();
        CTTextParagraph p = rich.addNewP();
        p.addNewR().setT(chartInfo.getTitle());
        List<RectCell> seriesList = chartInfo.getSeries();
        RectCell classify = chartInfo.getClassify().clone();
        classify.setFirstRow(classify.getFirstRow() + 1);
        String classifyStrRef = classify.formatAsString(sheetName, true);
        for (int i = 0; i < seriesList.size(); ++i) {
            RectCell series = seriesList.get(i);
            CTBarSer ctBarSer = ctBarChart.addNewSer();
            CTSerTx ctSerTx = ctBarSer.addNewTx();
            CTStrRef ctStrRef = ctSerTx.addNewStrRef();
            String colIndex = ParseUtils.num2Char(series.getFirstCol());
            ctStrRef.setF("'" + sheetName + "'!$" + colIndex + "$" + (series.getFirstRow() + 1));
            ctBarSer.addNewIdx().setVal((long)i);
            CTAxDataSource cttAxDataSource = ctBarSer.addNewCat();
            ctStrRef = cttAxDataSource.addNewStrRef();
            ctStrRef.setF(classifyStrRef);
            CTNumDataSource ctNumDataSource = ctBarSer.addNewVal();
            CTNumRef ctNumRef = ctNumDataSource.addNewNumRef();
            ctNumRef.setF("'" + sheetName + "'!$" + colIndex + "$" + (series.getFirstRow() + 2) + ":$" + colIndex + "$" + (series.getLastRow() + 1));
            ctBarSer.addNewInvertIfNegative().setVal(false);
            ctBarSer.addNewSpPr().addNewLn().addNewSolidFill().addNewSrgbClr().setVal(new byte[]{0, 0, 0});
            if (!chartInfo.getShowLabel()) continue;
            ctBoolean.setVal(false);
            CTDLbls newDLbls = ctBarSer.addNewDLbls();
            newDLbls.setShowLegendKey(ctBoolean);
            ctBoolean.setVal(true);
            newDLbls.setShowVal(ctBoolean);
            ctBoolean.setVal(false);
            newDLbls.setShowCatName(ctBoolean);
            newDLbls.setShowSerName(ctBoolean);
            newDLbls.setShowPercent(ctBoolean);
            newDLbls.setShowBubbleSize(ctBoolean);
            newDLbls.setShowLeaderLines(ctBoolean);
        }
        ctBarChart.addNewAxId().setVal(123456L);
        ctBarChart.addNewAxId().setVal(123457L);
        CTCatAx ctCatAx = ctPlotArea.addNewCatAx();
        ctCatAx.addNewAxId().setVal(123456L);
        CTScaling ctScaling = ctCatAx.addNewScaling();
        ctScaling.addNewOrientation().setVal(STOrientation.MIN_MAX);
        ctCatAx.addNewDelete().setVal(false);
        ctCatAx.addNewAxPos().setVal(STAxPos.B);
        ctCatAx.addNewCrossAx().setVal(123457L);
        ctCatAx.addNewTickLblPos().setVal(STTickLblPos.NEXT_TO);
        CTValAx ctValAx = ctPlotArea.addNewValAx();
        ctValAx.addNewAxId().setVal(123457L);
        ctScaling = ctValAx.addNewScaling();
        ctScaling.addNewOrientation().setVal(STOrientation.MIN_MAX);
        ctValAx.addNewDelete().setVal(false);
        ctValAx.addNewAxPos().setVal(STAxPos.L);
        ctValAx.addNewCrossAx().setVal(123456L);
        ctValAx.addNewTickLblPos().setVal(STTickLblPos.NEXT_TO);
        if (chartInfo.getShowLegend()) {
            CTLegend ctLegend = ctChart.addNewLegend();
            ctLegend.addNewLegendPos().setVal(STLegendPos.B);
            ctLegend.addNewOverlay().setVal(false);
        }
        CTLineChart ctLineChart = ctPlotArea.addNewLineChart();
        ctLineChart.addNewGrouping().setVal(STGrouping.STANDARD);
        List<RectCell> secondSeries = chartInfo.getSecondSeries();
        for (int i = 0; i < secondSeries.size(); ++i) {
            RectCell series = secondSeries.get(i);
            CTLineSer ctLineSer = ctLineChart.addNewSer();
            CTSerTx ctSerTx = ctLineSer.addNewTx();
            CTStrRef ctStrRef = ctSerTx.addNewStrRef();
            String colIndex = ParseUtils.num2Char(series.getFirstCol());
            ctStrRef.setF("'" + sheetName + "'!$" + colIndex + "$" + (series.getFirstRow() + 1));
            ctLineSer.addNewIdx().setVal((long)i);
            CTAxDataSource cttAxDataSource = ctLineSer.addNewCat();
            ctStrRef = cttAxDataSource.addNewStrRef();
            ctStrRef.setF(classifyStrRef);
            CTNumDataSource ctNumDataSource = ctLineSer.addNewVal();
            CTNumRef ctNumRef = ctNumDataSource.addNewNumRef();
            ctNumRef.setF("'" + sheetName + "'!$" + colIndex + "$" + (series.getFirstRow() + 2) + ":$" + colIndex + "$" + (series.getLastRow() + 1));
            ctLineSer.addNewSpPr().addNewLn().addNewSolidFill().addNewSrgbClr().setVal(new byte[]{0, 0, 0});
            if (chartInfo.getShowLabel()) {
                ctBoolean.setVal(false);
                CTDLbls newDLbls = ctLineSer.addNewDLbls();
                newDLbls.setShowLegendKey(ctBoolean);
                ctBoolean.setVal(true);
                newDLbls.setShowVal(ctBoolean);
                ctBoolean.setVal(false);
                newDLbls.setShowCatName(ctBoolean);
                newDLbls.setShowSerName(ctBoolean);
                newDLbls.setShowPercent(ctBoolean);
                newDLbls.setShowBubbleSize(ctBoolean);
                newDLbls.setShowLeaderLines(ctBoolean);
            }
            CTBoolean addNewSmooth = ctLineSer.addNewSmooth();
            addNewSmooth.setVal(false);
            CTMarker addNewMarker = ctLineSer.addNewMarker();
            CTMarkerStyle addNewSymbol = addNewMarker.addNewSymbol();
            addNewSymbol.setVal(STMarkerStyle.NONE);
        }
        ctLineChart.addNewAxId().setVal(1234567L);
        ctLineChart.addNewAxId().setVal(1234578L);
        CTCatAx ctCatAxline = ctPlotArea.addNewCatAx();
        ctCatAxline.addNewAxId().setVal(1234567L);
        CTScaling ctScalingline = ctCatAxline.addNewScaling();
        ctScalingline.addNewOrientation().setVal(STOrientation.MIN_MAX);
        ctCatAxline.addNewDelete().setVal(true);
        ctCatAxline.addNewAxPos().setVal(STAxPos.B);
        ctCatAxline.addNewMajorTickMark().setVal(STTickMark.OUT);
        ctCatAxline.addNewMinorTickMark().setVal(STTickMark.NONE);
        ctCatAxline.addNewAuto().setVal(true);
        ctCatAxline.addNewLblAlgn().setVal(STLblAlgn.CTR);
        ctCatAxline.addNewLblOffset().setVal(100);
        ctCatAxline.addNewNoMultiLvlLbl().setVal(false);
        ctCatAxline.addNewCrossAx().setVal(1234578L);
        ctCatAxline.addNewTickLblPos().setVal(STTickLblPos.NEXT_TO);
        CTValAx ctValAxline = ctPlotArea.addNewValAx();
        ctValAxline.addNewAxId().setVal(1234578L);
        ctScalingline = ctValAxline.addNewScaling();
        ctScalingline.addNewOrientation().setVal(STOrientation.MIN_MAX);
        ctValAxline.addNewDelete().setVal(false);
        ctValAxline.addNewAxPos().setVal(STAxPos.R);
        ctValAxline.addNewMajorTickMark().setVal(STTickMark.OUT);
        ctValAxline.addNewMinorTickMark().setVal(STTickMark.NONE);
        ctValAxline.addNewCrosses().setVal(STCrosses.MAX);
        ctValAxline.addNewCrossBetween().setVal(STCrossBetween.BETWEEN);
        ctValAxline.addNewCrossAx().setVal(1234567L);
        ctValAxline.addNewTickLblPos().setVal(STTickLblPos.NEXT_TO);
    }
}

