/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.service.impl;

import com.tydic.common.model.ExcelData;
import com.tydic.common.model.SheetData;
import com.tydic.common.service.ExportExcelService;
import com.tydic.common.utils.XSSFStyleUtil;
import com.tydic.common.writeTask.WriteSheetTask2;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportExcelServiceImpl
implements ExportExcelService {
    private static final Logger log = LoggerFactory.getLogger(ExportExcelServiceImpl.class);
    private final int WINDOW_SIZE = 1000;

    @Override
    public void exportExcel(ExcelData excelData, OutputStream outputStream) {
        SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
        XSSFStyleUtil styleUtil = XSSFStyleUtil.create(workbook);
        ArrayList<Integer> indexList = new ArrayList<Integer>(excelData.getSheetDataMap().keySet());
        indexList.sort((o1, o2) -> -o1.compareTo((Integer)o2));
        ExecutorService executor = Executors.newFixedThreadPool(indexList.size());
        CountDownLatch downLatch = new CountDownLatch(indexList.size());
        Iterator iterator = indexList.iterator();
        while (iterator.hasNext()) {
            int sheetIndex = (Integer)iterator.next();
            SheetData sheetData = excelData.getSheetDataMap().get(sheetIndex);
            sheetData.setHeaderRow(excelData.getHeaderRow());
            String sheetName = sheetData.getSheetName();
            if (StringUtils.isBlank((CharSequence)sheetName)) {
                sheetName = "sheet_" + sheetIndex;
            }
            SXSSFSheet sheet = workbook.createSheet(sheetName);
            WriteSheetTask2 task = new WriteSheetTask2(sheet, sheetData, styleUtil, downLatch);
            executor.submit(task);
        }
        try {
            downLatch.await();
            executor.shutdown();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            workbook.write(outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

