/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.service.impl;

import com.tydic.common.dbService.DatabaseService;
import com.tydic.common.dbService.DbColumn;
import com.tydic.common.dbService.DbDataSource;
import com.tydic.common.dbService.factory.DatabaseServiceFactory;
import com.tydic.common.handle.AnalysisContentsHandler;
import com.tydic.common.handle.CheckContentsHandler;
import com.tydic.common.handle.SheetContentsHandler;
import com.tydic.common.reader.ExcelSAXReader;
import com.tydic.common.service.ImportExcelService;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExcelServiceImpl
implements ImportExcelService {
    private static final Logger log = LoggerFactory.getLogger(ImportExcelServiceImpl.class);

    @Override
    public List<Map> checkExcel(InputStream fileStream) throws Exception {
        CheckContentsHandler handler = new CheckContentsHandler();
        ExcelSAXReader.read(fileStream, (SheetContentsHandler)handler);
        return handler.getCheckMapList();
    }

    @Override
    public List<Map> checkExcel(File excelFile, DbDataSource dataSource, List<Map> reCheckList) {
        return null;
    }

    @Override
    public void importExcel(InputStream fileStream, DbDataSource dataSource, List<Map> param) throws Exception {
        DatabaseService databaseService = DatabaseServiceFactory.createDatabaseService(dataSource);
        Map<String, Map<String, Object>> lostMap = this.checkTable(databaseService, param);
        if (null == lostMap) {
            log.error("\u8fde\u63a5\u6570\u636e\u5e93\u5f02\u5e38\uff01");
            throw new Exception("\u8fde\u63a5\u6570\u636e\u5e93\u5f02\u5e38\uff01");
        }
        if (!lostMap.isEmpty()) {
            String lostMsg = this.createLostMsg(lostMap);
            log.error("\u6587\u4ef6\u7f3a\u5931\u5b57\u6bb5\uff01{}", (Object)lostMsg);
            throw new Exception(lostMsg);
        }
        AnalysisContentsHandler handler = new AnalysisContentsHandler(databaseService, param);
        ExcelSAXReader.read(fileStream, (SheetContentsHandler)handler);
    }

    private String createLostMsg(Map<String, Map<String, Object>> checkMap) {
        StringBuilder msg = new StringBuilder();
        for (String tableName : checkMap.keySet()) {
            List moreList;
            Map<String, Object> tableMap = checkMap.get(tableName);
            List lostList = (List)tableMap.get("lost");
            String sheetName = (String)tableMap.get("SheetName");
            if (null != lostList && !lostList.isEmpty()) {
                msg.append("sheet[").append(sheetName).append("]=>\u8868[").append(tableName).append("]\n\u7f3a\u5931\u4ee5\u4e0b\u5b57\u6bb5\uff1a\n");
                for (DbColumn column : lostList) {
                    msg.append("\u5b57\u6bb5\u540d[").append(column.getName()).append("],\u7c7b\u578b[").append(column.getType()).append("];\n ");
                }
                msg.deleteCharAt(msg.length() - 1);
                msg.append("\u3002");
            }
            if (null == (moreList = (List)tableMap.get("more")) || moreList.isEmpty()) continue;
            msg.append("\u4e0a\u4f20\u6587\u4ef6\u5b58\u5728\u4ee5\u4e0b\u591a\u4f59\u5b57\u6bb5\uff1a\n");
            for (DbColumn column : moreList) {
                msg.append("\u5b57\u6bb5\u540d[").append(column.getName()).append("],\u7c7b\u578b[").append(column.getType()).append("];\n");
            }
            msg.deleteCharAt(msg.length() - 1);
            msg.append("\u3002");
        }
        return msg.toString();
    }

    private Map<String, Map<String, Object>> checkTable(DatabaseService databaseService, List<Map> param) throws Exception {
        if (null == databaseService) {
            return null;
        }
        if (!databaseService.checkDatabase()) {
            return null;
        }
        HashMap<String, Map<String, Object>> lostMap = new HashMap<String, Map<String, Object>>();
        for (Map item : param) {
            Map<String, Object> lostList;
            boolean createAble = (Boolean)item.get("createTable");
            boolean clearAble = (Boolean)item.get("clearTable");
            String tableName = (String)item.get("tableName");
            List columnList = (List)item.get("columnList");
            boolean hasTable = databaseService.checkHasTable(tableName);
            if (createAble) {
                int repeatCount = 0;
                String originName = tableName;
                while (hasTable) {
                    tableName = originName + "_excel_" + repeatCount;
                    hasTable = databaseService.checkHasTable(tableName);
                    ++repeatCount;
                }
                item.put("tableName", tableName);
                databaseService.createTable(tableName, columnList);
                continue;
            }
            if (!hasTable) {
                databaseService.createTable(tableName, columnList);
            }
            if (!(lostList = databaseService.checkHasCol(tableName, columnList)).isEmpty()) {
                lostList.put("tableName", tableName);
                lostList.put("SheetName", item.get("SheetName"));
                lostMap.put(tableName, lostList);
            }
            if (!clearAble || !lostMap.isEmpty()) continue;
            databaseService.delete(tableName);
        }
        return lostMap;
    }
}

