/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.utils;

import com.tydic.common.analysis.v07.BaseXSSFXMLHandler;
import com.tydic.common.constant.Constants;
import com.tydic.common.constant.ExcelDataType;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DataTypeUtils {
    public static ExcelDataType getType(BaseXSSFXMLHandler.xssfDataType dataType, String formattedValue, String formatString) {
        switch (dataType) {
            case NUMBER: {
                return DataTypeUtils.getTypeForNumber(formattedValue, formatString);
            }
            case ERROR: {
                return ExcelDataType.ERROR;
            }
            case BOOLEAN: {
                return ExcelDataType.ERROR;
            }
            case SST_STRING: 
            case INLINE_STRING: {
                return ExcelDataType.STRING;
            }
        }
        return ExcelDataType.STRING;
    }

    public static ExcelDataType getTypeForNumber(String formattedValue, String formatString) {
        ExcelDataType type = DataTypeUtils.getCustomType(formatString);
        if (null == type) {
            return DataTypeUtils.getNumberType(formattedValue);
        }
        return type;
    }

    private static ExcelDataType getNumberType(String value) {
        if (value.contains("%")) {
            return ExcelDataType.DOUBLE;
        }
        String[] tmp = value.split("\\.");
        if (tmp.length == 1) {
            return ExcelDataType.INT;
        }
        return ExcelDataType.DOUBLE;
    }

    public static ExcelDataType getCustomType(String formatString) {
        if (StringUtils.isBlank((CharSequence)formatString)) {
            return null;
        }
        if ("@".equals(formatString)) {
            return ExcelDataType.STRING;
        }
        int weight = 0;
        if (formatString.contains("m")) {
            ++weight;
        }
        if (formatString.contains("y") || formatString.contains("d")) {
            weight += 2;
        }
        if (formatString.contains("h") || formatString.contains("s")) {
            weight += 4;
        }
        if (DataTypeUtils.between(weight, 1, 3)) {
            return ExcelDataType.DATE;
        }
        if (DataTypeUtils.between(weight, 4, 5)) {
            return ExcelDataType.TIME;
        }
        if (DataTypeUtils.between(weight, 6, 7)) {
            return ExcelDataType.DATETIME;
        }
        return null;
    }

    public static boolean between(int value, int left, int right) {
        return value >= left && value <= right;
    }

    public static String fixDateType(String value, ExcelDataType type, String formatString) {
        switch (type) {
            case DATE: {
                Date date = new Date(value);
                value = Constants.DATE_FORMAT_DATE.format(date);
                break;
            }
            case DATETIME: {
                Date dateTime = new Date(value);
                value = Constants.DATE_FORMAT_DATETIME.format(dateTime);
                break;
            }
            case DOUBLE: {
                if (!StringUtils.isNotBlank((CharSequence)formatString) || !formatString.contains("%") || !value.contains("%")) break;
                value = String.valueOf(Double.valueOf(value.split("%")[0]) * 0.01);
            }
        }
        return value;
    }
}

