/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.utils;

import com.tydic.common.model.ExcelColumn;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ParseUtils {
    public static int parseInt(Object value) {
        return Integer.valueOf(String.valueOf(value).split("\\.")[0]);
    }

    public static double parseDouble(Object value) {
        return Double.valueOf(String.valueOf(value).split("\\.")[0]);
    }

    public static Color parseColor(String colorCode) {
        if (3 == colorCode.length()) {
            String r = String.valueOf(colorCode.charAt(0));
            String g = String.valueOf(colorCode.charAt(1));
            String b = String.valueOf(colorCode.charAt(2));
            colorCode = r + r + g + g + b + b;
        }
        return new Color(Integer.valueOf(colorCode, 16));
    }

    public static double pxParsePound(double px) {
        return px / 1.3;
    }

    public static String num2Char(int num) {
        return (char)(65 + num) + "";
    }

    public static List<ExcelColumn> mapToColumn(List<Map> list) throws Exception {
        ArrayList<ExcelColumn> columnList = new ArrayList<ExcelColumn>();
        for (Map tmpItem : list) {
            if (tmpItem instanceof ExcelColumn) {
                columnList.add((ExcelColumn)((Object)tmpItem));
                continue;
            }
            if (!(tmpItem instanceof Map)) continue;
            ExcelColumn column = ParseUtils.mapToColumn(tmpItem);
            columnList.add(column);
        }
        return columnList;
    }

    public static ExcelColumn mapToColumn(Map map) throws Exception {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class T = ExcelColumn.class; null != T; T = T.getSuperclass()) {
            Field[] fields = T.getDeclaredFields();
            fieldList.addAll(Arrays.asList(fields));
        }
        ExcelColumn column = new ExcelColumn();
        for (Field f : fieldList) {
            Method method;
            Object value = map.get(f.getName());
            if (null == value || null == (method = ExcelColumn.class.getMethod("set" + ParseUtils.toFirstUpCase(f.getName()), f.getType()))) continue;
            if (Integer.class.equals(f.getType())) {
                value = ParseUtils.parseInt(value);
            }
            method.invoke((Object)column, value);
        }
        return column;
    }

    public static String toFirstUpCase(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

