/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.utils;

import com.tydic.common.constant.StyleName;
import com.tydic.common.model.Border;
import com.tydic.common.model.BorderLine;
import com.tydic.common.utils.ParseUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class XSSFStyleUtil {
    private SXSSFWorkbook workbook;
    private Map<String, XSSFCellStyle> styleMap = new HashMap<String, XSSFCellStyle>();

    public static XSSFStyleUtil create(SXSSFWorkbook workbook) {
        XSSFStyleUtil styleUtil = new XSSFStyleUtil();
        styleUtil.setWorkbook(workbook);
        return styleUtil;
    }

    public SXSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(SXSSFWorkbook workbook) {
        this.workbook = workbook;
    }

    public Map<String, XSSFCellStyle> getStyleMap() {
        return this.styleMap;
    }

    public void setStyleMap(Map<String, XSSFCellStyle> styleMap) {
        this.styleMap = styleMap;
    }

    public XSSFCellStyle build(Map<String, String> param) {
        StringBuilder key = new StringBuilder();
        for (String StyleName2 : StyleName.KEY_ORDER) {
            String value = param.get(StyleName2);
            key.append(value).append("-");
        }
        key.deleteCharAt(key.length() - 1);
        XSSFCellStyle style = this.styleMap.get(key.toString());
        if (null == style) {
            style = this.createStyle(param);
            this.styleMap.put(key.toString(), style);
        }
        return style;
    }

    public XSSFCellStyle build(String key) {
        XSSFCellStyle style = this.styleMap.get(key);
        if (null == style) {
            style = this.createStyle(key);
            this.styleMap.put(key, style);
        }
        return style;
    }

    private XSSFCellStyle createStyle(Map<String, String> param) {
        XSSFCellStyle style = this.workbook.getXSSFWorkbook().createCellStyle();
        XSSFFont font = this.workbook.getXSSFWorkbook().createFont();
        for (String styleName : param.keySet()) {
            String value = param.get(styleName);
            if (StringUtils.isBlank((CharSequence)value)) continue;
            switch (styleName) {
                case "cellFontFamily": {
                    font.setFontName(value);
                    break;
                }
                case "cellFontSize": {
                    double fontHeight = ParseUtils.pxParsePound(Double.valueOf(value));
                    font.setFontHeight(fontHeight);
                    break;
                }
                case "cellFontBold": {
                    font.setBold(Boolean.valueOf(value).booleanValue());
                    break;
                }
                case "cellFontColor": {
                    XSSFColor color = new XSSFColor(ParseUtils.parseColor(value));
                    font.setColor(color);
                    break;
                }
                case "cellBackgroundColor": {
                    XSSFColor backColor = new XSSFColor(ParseUtils.parseColor(value));
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    style.setFillForegroundColor(backColor);
                    break;
                }
                case "cellTextHorizontal": {
                    style.setAlignment(HorizontalAlignment.values()[Integer.valueOf(value)]);
                    break;
                }
                case "cellTextVertical": {
                    style.setVerticalAlignment(VerticalAlignment.values()[Integer.valueOf(value)]);
                    break;
                }
                case "cellBorder": {
                    Border border = Border.build(value);
                    this.setBorder(style, border);
                }
            }
        }
        style.setFont((Font)font);
        style.setWrapText(true);
        return style;
    }

    private XSSFCellStyle createStyle(String key) {
        XSSFCellStyle style = this.workbook.getXSSFWorkbook().createCellStyle();
        XSSFFont font = this.workbook.getXSSFWorkbook().createFont();
        String[] param = key.split("-");
        block20: for (int i = 0; i < StyleName.KEY_ORDER.length; ++i) {
            String styleName = StyleName.KEY_ORDER[i];
            String value = param[i];
            if (StringUtils.isBlank((CharSequence)value) || "null".equals(value)) continue;
            switch (styleName) {
                case "cellFontFamily": {
                    font.setFontName(value);
                    continue block20;
                }
                case "cellFontSize": {
                    double fontHeight = ParseUtils.pxParsePound(Double.valueOf(value));
                    font.setFontHeight(fontHeight);
                    continue block20;
                }
                case "cellFontBold": {
                    font.setBold(Boolean.valueOf(value).booleanValue());
                    continue block20;
                }
                case "cellFontColor": {
                    XSSFColor color = new XSSFColor(ParseUtils.parseColor(value));
                    font.setColor(color);
                    continue block20;
                }
                case "cellBackgroundColor": {
                    XSSFColor backColor = new XSSFColor(ParseUtils.parseColor(value));
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    style.setFillForegroundColor(backColor);
                    continue block20;
                }
                case "cellTextHorizontal": {
                    style.setAlignment(HorizontalAlignment.values()[Integer.valueOf(value)]);
                    continue block20;
                }
                case "cellTextVertical": {
                    style.setVerticalAlignment(VerticalAlignment.values()[Integer.valueOf(value)]);
                    continue block20;
                }
                case "cellBorder": {
                    Border border = Border.build(value);
                    this.setBorder(style, border);
                }
            }
        }
        style.setFont((Font)font);
        style.setWrapText(true);
        return style;
    }

    private void setBorder(XSSFCellStyle style, Border border) {
        BorderLine right;
        BorderLine left;
        BorderLine bottom;
        BorderLine top = border.getTopBorder();
        if (null != top) {
            style.setBorderTop(BorderStyle.values()[top.getStyle()]);
            style.setTopBorderColor(new XSSFColor(new Color(top.getColor())));
        }
        if (null != (bottom = border.getBottomBorder())) {
            style.setBorderBottom(BorderStyle.values()[bottom.getStyle()]);
            style.setBottomBorderColor(new XSSFColor(new Color(bottom.getColor())));
        }
        if (null != (left = border.getLeftBorder())) {
            style.setBorderLeft(BorderStyle.values()[left.getStyle()]);
            style.setLeftBorderColor(new XSSFColor(new Color(left.getColor())));
        }
        if (null != (right = border.getRightBorder())) {
            style.setBorderRight(BorderStyle.values()[right.getStyle()]);
            style.setRightBorderColor(new XSSFColor(new Color(right.getColor())));
        }
    }
}

