/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.writeTask;

import com.tydic.common.model.SheetData;
import com.tydic.common.utils.ParseUtils;
import com.tydic.common.utils.XSSFStyleUtil;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteRowTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(WriteRowTask.class);
    private final int threshold = 10000;
    private int start;
    private int end;
    private Sheet sheet;
    private SheetData sheetData;
    private XSSFStyleUtil styleUtil;
    private CountDownLatch downLatch;
    private Semaphore semaphore;

    public WriteRowTask(int start, int end, Sheet sheet, SheetData sheetData, XSSFStyleUtil styleUtil, CountDownLatch downLatch, Semaphore semaphore) {
        this.start = start;
        this.end = end;
        this.sheet = sheet;
        this.sheetData = sheetData;
        this.styleUtil = styleUtil;
        this.downLatch = downLatch;
        this.semaphore = semaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("{} begin exec...", (Object)Thread.currentThread().getName());
        try {
            this.semaphore.acquire();
            log.info("{} handle rows:{}", (Object)Thread.currentThread().getName(), (Object)this.sheetData.getData().size());
            Row excelRow = null;
            for (int row = 0; row < this.end; ++row) {
                excelRow = this.createRow(this.sheet, row);
                excelRow.setHeightInPoints((float)ParseUtils.pxParsePound(this.sheetData.getRowHeights()));
                Cell cell = null;
                Object value = null;
                Map<String, String> param = null;
                XSSFCellStyle style = null;
                for (int col = 0; col < this.sheetData.getColCount(); ++col) {
                    cell = excelRow.createCell(col);
                    value = this.sheetData.getValue(row, col);
                    if (null != value) {
                        cell.setCellValue(value.toString());
                    }
                    if (row >= this.sheetData.getHeaderRow()) continue;
                    param = this.sheetData.getStyleMap(row, col);
                    style = this.styleUtil.build(param);
                    cell.setCellStyle((CellStyle)style);
                }
            }
            this.downLatch.countDown();
        }
        catch (Exception e) {
            try {
                log.error("\u5904\u7406\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
                this.downLatch.countDown();
            }
            catch (Throwable throwable) {
                this.downLatch.countDown();
                log.info("thred:{}, start:{},end:{},count:{}", new Object[]{Thread.currentThread().getName(), this.start, this.end, this.downLatch.getCount()});
                this.semaphore.release();
                throw throwable;
            }
            log.info("thred:{}, start:{},end:{},count:{}", new Object[]{Thread.currentThread().getName(), this.start, this.end, this.downLatch.getCount()});
            this.semaphore.release();
        }
        log.info("thred:{}, start:{},end:{},count:{}", new Object[]{Thread.currentThread().getName(), this.start, this.end, this.downLatch.getCount()});
        this.semaphore.release();
    }

    private Row createRow(Sheet sheet, int rowIndex) {
        return sheet.createRow(rowIndex);
    }
}

