/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.writeTask;

import com.tydic.common.model.CellData;
import com.tydic.common.model.SheetData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteRowTask2
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(WriteRowTask2.class);
    private int start;
    private int end;
    private SheetData sheetData;
    private CountDownLatch downLatch;
    private Semaphore semaphore;
    private List<List<CellData>> taskData;

    public WriteRowTask2(int start, int end, SheetData sheetData, CountDownLatch downLatch, Semaphore semaphore, List<List<CellData>> taskData) {
        this.start = start;
        this.end = end;
        this.sheetData = sheetData;
        this.downLatch = downLatch;
        this.semaphore = semaphore;
        this.taskData = taskData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.semaphore.acquire();
            for (int rowIndex = this.start; rowIndex < this.end; ++rowIndex) {
                int colCount = this.sheetData.getColCount(rowIndex);
                ArrayList<CellData> rowData = new ArrayList<CellData>();
                for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                    Object val = this.sheetData.getValue(rowIndex, colIndex);
                    String key = this.sheetData.getStyleKey(rowIndex, colIndex);
                    CellData cellData = new CellData(val, key);
                    rowData.add(cellData);
                }
                this.taskData.add(rowData);
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.downLatch.countDown();
            this.semaphore.release();
            log.debug("handle row finish:start:{} end:{}", (Object)this.start, (Object)this.end);
        }
    }
}

