/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.writeTask;

import com.tydic.common.model.ChartInfo;
import com.tydic.common.model.Line;
import com.tydic.common.model.RectCell;
import com.tydic.common.model.SheetData;
import com.tydic.common.model.SlantLine;
import com.tydic.common.service.impl.BuildChartServiceImpl;
import com.tydic.common.utils.SplitData;
import com.tydic.common.utils.XSSFStyleUtil;
import com.tydic.common.writeTask.WriteRowTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Chart;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.XSSFChildAnchor;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFShapeGroup;
import org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteSheetTask
implements Callable<Integer> {
    private static final Logger log = LoggerFactory.getLogger(WriteSheetTask.class);
    private Sheet sheet;
    private SheetData sheetData;
    private XSSFStyleUtil styleUtil;
    private CountDownLatch downLatch = null;
    private int singleCount = 1000;
    private final int pageCount = 20;

    public WriteSheetTask(Sheet sheet, SheetData sheetData, XSSFStyleUtil styleUtil) {
        this.sheet = sheet;
        this.sheetData = sheetData;
        this.styleUtil = styleUtil;
    }

    @Override
    public Integer call() {
        RectCell freezePanel;
        List<ChartInfo> chartInfoList;
        List<SlantLine> slantLineList;
        int sum = 0;
        List<SplitData> totalProcessIndex = this.splitSheetData(this.sheetData.getRowCount());
        ArrayList splitProcessDataList = new ArrayList();
        ExecutorService executorService = Executors.newFixedThreadPool(totalProcessIndex.size());
        this.downLatch = new CountDownLatch(totalProcessIndex.size());
        Semaphore semaphore = new Semaphore(8);
        log.info("total process :{}", (Object)totalProcessIndex.size());
        totalProcessIndex.sort(SplitData::getSort);
        Stream.iterate(0, n -> n + 1).limit(totalProcessIndex.size()).forEach(i -> splitProcessDataList.add(this.sheetData.getData().stream().skip(i * this.singleCount).limit(this.singleCount).collect(Collectors.toList())));
        SXSSFWorkbook wb = null;
        SXSSFSheet splitSheet = null;
        XSSFStyleUtil splitStyleUtil = null;
        long begingTime = System.currentTimeMillis();
        for (SplitData splitData : totalProcessIndex) {
            List splitDataList = (List)splitProcessDataList.get(splitData.getOrder());
            Object splitSheetData = null;
            wb = new SXSSFWorkbook();
            splitSheet = wb.createSheet();
            try {
                splitSheetData = (SheetData)this.sheetData.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            ((SheetData)splitSheetData).setData(splitDataList);
            log.info("process count:{},{}", (Object)splitDataList.size(), (Object)splitData.toString());
            WriteRowTask writeRowTask = new WriteRowTask(0, splitDataList.size(), (Sheet)splitSheet, (SheetData)splitSheetData, splitStyleUtil, this.downLatch, semaphore);
            executorService.submit(new Thread(writeRowTask));
            splitData.setSheet((Sheet)splitSheet);
        }
        try {
            this.downLatch.await();
            executorService.shutdown();
            log.info("\u6570\u636e\u5b50\u4efb\u52a1\u5904\u7406\u5b8c\u6bd5\uff0c\u8017\u65f6\uff1a{} \u6beb\u79d2", (Object)(System.currentTimeMillis() - begingTime));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.debug("sheet number:{},lastRowNum() :{},headerRow:{}", new Object[]{this.sheet.getWorkbook().getNumberOfSheets(), this.sheet.getLastRowNum(), this.sheetData.getHeaderRow()});
        int rowIndex = 0;
        Object param = null;
        HashMap<String, CellStyle> rowCellStyle = new HashMap<String, CellStyle>();
        for (SplitData splitData : totalProcessIndex) {
            Object excelRow = null;
            for (Row cells : splitData.getSheet()) {
                excelRow = this.sheet.createRow(rowIndex);
                Cell cell = null;
                CellStyle style = null;
                for (int i2 = 0; i2 < cells.getLastCellNum(); ++i2) {
                    cell = excelRow.createCell(i2);
                    cell.setCellValue(cells.getCell(i2).getStringCellValue());
                    if (rowIndex >= this.sheetData.getHeaderRow()) continue;
                    style = (CellStyle)rowCellStyle.get(this.calcRowCellIndex(rowIndex, i2));
                    if (style == null) {
                        style = this.sheet.getWorkbook().createCellStyle();
                        rowCellStyle.put(this.calcRowCellIndex(rowIndex, i2), style);
                    }
                    style.cloneStyleFrom(cells.getCell(i2).getCellStyle());
                    cell.setCellStyle(style);
                }
                ++rowIndex;
            }
        }
        totalProcessIndex.clear();
        int width = (int)((double)this.sheetData.getColWidths() / 8.0 * 256.0);
        for (int j = 0; j < this.sheetData.getColCount(); ++j) {
            this.sheet.setColumnWidth(j, width);
        }
        List<RectCell> mergeCellList = this.sheetData.getMergeCellList();
        if (null != mergeCellList && !mergeCellList.isEmpty()) {
            for (RectCell mergeCell : mergeCellList) {
                CellRangeAddress rangeAddress = new CellRangeAddress(mergeCell.getFirstRow(), mergeCell.getLastRow(), mergeCell.getFirstCol(), mergeCell.getLastCol());
                this.sheet.addMergedRegion(rangeAddress);
            }
        }
        if (null != (slantLineList = this.sheetData.getSlantLineList()) && !slantLineList.isEmpty()) {
            this.drawLine(this.sheetData, this.sheet, slantLineList);
        }
        if (null != (chartInfoList = this.sheetData.getChartInfoList()) && !chartInfoList.isEmpty()) {
            for (ChartInfo chartInfo : chartInfoList) {
                this.createChart(this.sheet, chartInfo);
            }
        }
        if (null != (freezePanel = this.sheetData.getFreezePanel())) {
            this.sheet.createFreezePane(freezePanel.getFirstCol(), freezePanel.getFirstRow(), freezePanel.getFirstCol(), freezePanel.getFirstRow());
        }
        return sum;
    }

    private void drawLine(SheetData sheetData, Sheet sheet, List<SlantLine> slantLineList) {
        for (SlantLine slantLine : slantLineList) {
            RectCell cell = slantLine.getCell();
            List<Line> lineList = slantLine.getLineList();
            XSSFDrawing xssfDrawing = ((SXSSFSheet)sheet).getDrawingPatriarch();
            if (null == xssfDrawing) {
                sheet.createDrawingPatriarch();
                xssfDrawing = ((SXSSFSheet)sheet).getDrawingPatriarch();
            }
            int height = sheetData.getRowHeights() * (cell.getLastRow() - cell.getFirstRow() + 1);
            int width = sheetData.getColWidths() * (cell.getLastCol() - cell.getFirstCol() + 1);
            XSSFShapeGroup group = xssfDrawing.createGroup(xssfDrawing.createAnchor(0, 0, 12700 * width, 12700 * height, cell.getFirstCol(), cell.getFirstRow(), cell.getLastCol(), cell.getLastRow()));
            group.setCoordinates(0, 0, 12700 * width, 12700 * height);
            for (Line line : lineList) {
                int d;
                int x = line.getStartx() * 12700;
                int y = line.getStarty() * 12700;
                int cx = line.getEndx() * 12700;
                int cy = line.getEndy() * 12700;
                if (x > cx) {
                    d = x - cx;
                    x -= d;
                    cx -= d;
                }
                if (y > cy) {
                    d = y - cy;
                    y -= d;
                    cy -= d;
                }
                XSSFChildAnchor childAnchor = new XSSFChildAnchor(x, y, cx, cy);
                XSSFSimpleShape lineShape = group.createSimpleShape(childAnchor);
                lineShape.setShapeType(1);
                lineShape.setLineStyle(0);
                lineShape.setLineStyleColor(0, 0, 0);
            }
        }
    }

    private void createChart(Sheet sheet, ChartInfo chartInfo) {
        XSSFDrawing xssfDrawing = ((SXSSFSheet)sheet).getDrawingPatriarch();
        if (null == xssfDrawing) {
            sheet.createDrawingPatriarch();
            xssfDrawing = ((SXSSFSheet)sheet).getDrawingPatriarch();
        }
        RectCell location = chartInfo.getLocation();
        XSSFClientAnchor anchor = xssfDrawing.createAnchor(0, 0, 0, 0, location.getFirstCol(), location.getFirstRow(), location.getLastCol(), location.getLastRow());
        XSSFChart chart = xssfDrawing.createChart((ClientAnchor)anchor);
        BuildChartServiceImpl buildChartService = new BuildChartServiceImpl();
        switch (chartInfo.getType()) {
            case "bar": {
                buildChartService.buildBar((Chart)chart, chartInfo, sheet.getSheetName());
                break;
            }
            case "pie": {
                buildChartService.buildPie((Chart)chart, chartInfo, sheet.getSheetName());
                break;
            }
            case "bar-line": {
                buildChartService.buildBarLine((Chart)chart, chartInfo, sheet.getSheetName());
                break;
            }
            default: {
                buildChartService.buildBar((Chart)chart, chartInfo, sheet.getSheetName());
            }
        }
    }

    public List<SplitData> splitSheetData(int count) {
        ArrayList<SplitData> splitList = new ArrayList<SplitData>();
        if (count / this.singleCount == 0) {
            splitList.add(new SplitData(0, 0, count % this.singleCount, null));
        } else {
            for (int i = 0; i < count / this.singleCount; ++i) {
                splitList.add(new SplitData(i, i * this.singleCount, (i + 1) * this.singleCount - 1, null));
                if (i + 1 != count / this.singleCount || count % this.singleCount == 0) continue;
                splitList.add(new SplitData(i + 1, i * this.singleCount + this.singleCount, i * this.singleCount + this.singleCount + count % this.singleCount, null));
            }
        }
        return splitList;
    }

    private String calcRowCellIndex(int rowIndex, int colIndex) {
        return rowIndex % 20 + "_" + colIndex;
    }
}

