/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.common.writeTask;

import com.tydic.common.model.CellData;
import com.tydic.common.model.ChartInfo;
import com.tydic.common.model.Line;
import com.tydic.common.model.RectCell;
import com.tydic.common.model.SheetData;
import com.tydic.common.model.SlantLine;
import com.tydic.common.service.impl.BuildChartServiceImpl;
import com.tydic.common.utils.XSSFStyleUtil;
import com.tydic.common.writeTask.WriteRowTask2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Chart;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.XSSFChildAnchor;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFShapeGroup;
import org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteSheetTask2
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(WriteSheetTask2.class);
    private final int singleCount = 1000;
    private SXSSFSheet sheet;
    private SheetData sheetData;
    private XSSFStyleUtil styleUtil;
    private CountDownLatch downLatch;

    public WriteSheetTask2(SXSSFSheet sheet, SheetData sheetData, XSSFStyleUtil styleUtil, CountDownLatch downLatch) {
        this.sheet = sheet;
        this.sheetData = sheetData;
        this.styleUtil = styleUtil;
        this.downLatch = downLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        try {
            RectCell freezePanel;
            List<ChartInfo> chartInfoList;
            List<SlantLine> slantLineList;
            void var11_18;
            int rowCount = this.sheetData.getRowCount();
            int size = rowCount / 1000 + 1;
            ExecutorService executor = Executors.newFixedThreadPool(size);
            CountDownLatch childCountDown = new CountDownLatch(size);
            Semaphore semaphore = new Semaphore(8);
            ArrayList allCellData = new ArrayList();
            long beginTime = System.currentTimeMillis();
            for (int i = 0; i < size; ++i) {
                int start = i * 1000;
                int n = (i + 1) * 1000;
                Iterator<RectCell> taskData = new ArrayList();
                allCellData.add(taskData);
                WriteRowTask2 task = new WriteRowTask2(start, n, this.sheetData, childCountDown, semaphore, (List<List<CellData>>)((Object)taskData));
                executor.submit(task);
            }
            try {
                childCountDown.await();
                executor.shutdown();
                log.info("\u6570\u636e\u5b50\u4efb\u52a1\u5904\u7406\u5b8c\u6bd5\uff0c\u8017\u65f6\uff1a{} \u6beb\u79d2", (Object)(System.currentTimeMillis() - beginTime));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            int rowIndex = 0;
            for (List list : allCellData) {
                for (List rowList : list) {
                    SXSSFRow excelRow = this.sheet.createRow(rowIndex);
                    int colIndex = 0;
                    for (CellData cellData : rowList) {
                        Cell cell = excelRow.createCell(colIndex);
                        Object val = cellData.getVal();
                        if (null != val) {
                            if (val instanceof Integer) {
                                cell.setCellValue((double)((Integer)val).intValue());
                            } else if (val instanceof Number) {
                                cell.setCellValue(Double.valueOf(String.valueOf(val)).doubleValue());
                            } else {
                                cell.setCellValue(String.valueOf(val));
                            }
                        }
                        String styleKey = cellData.getStyleKey();
                        XSSFCellStyle style = this.styleUtil.build(styleKey);
                        cell.setCellStyle((CellStyle)style);
                        ++colIndex;
                    }
                    ++rowIndex;
                }
            }
            int width = (int)((double)this.sheetData.getColWidths() / 8.0 * 256.0);
            boolean bl = false;
            while (var11_18 < this.sheetData.getColCount()) {
                this.sheet.setColumnWidth((int)var11_18, width);
                ++var11_18;
            }
            List<RectCell> list = this.sheetData.getMergeCellList();
            if (null != list && !list.isEmpty()) {
                for (RectCell mergeCell : list) {
                    CellRangeAddress rangeAddress = new CellRangeAddress(mergeCell.getFirstRow(), mergeCell.getLastRow(), mergeCell.getFirstCol(), mergeCell.getLastCol());
                    this.sheet.addMergedRegion(rangeAddress);
                }
            }
            if (null != (slantLineList = this.sheetData.getSlantLineList()) && !slantLineList.isEmpty()) {
                this.drawLine(this.sheetData, this.sheet, slantLineList);
            }
            if (null != (chartInfoList = this.sheetData.getChartInfoList()) && !chartInfoList.isEmpty()) {
                for (ChartInfo chartInfo : chartInfoList) {
                    this.createChart(this.sheet, chartInfo);
                }
            }
            if (null != (freezePanel = this.sheetData.getFreezePanel())) {
                this.sheet.createFreezePane(freezePanel.getFirstCol(), freezePanel.getFirstRow(), freezePanel.getFirstCol(), freezePanel.getFirstRow());
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.downLatch.countDown();
        }
    }

    private void drawLine(SheetData sheetData, SXSSFSheet sheet, List<SlantLine> slantLineList) {
        for (SlantLine slantLine : slantLineList) {
            RectCell cell = slantLine.getCell();
            List<Line> lineList = slantLine.getLineList();
            XSSFDrawing xssfDrawing = sheet.getDrawingPatriarch();
            if (null == xssfDrawing) {
                sheet.createDrawingPatriarch();
                xssfDrawing = sheet.getDrawingPatriarch();
            }
            int height = sheetData.getRowHeights() * (cell.getLastRow() - cell.getFirstRow() + 1);
            int width = sheetData.getColWidths() * (cell.getLastCol() - cell.getFirstCol() + 1);
            XSSFShapeGroup group = xssfDrawing.createGroup(xssfDrawing.createAnchor(0, 0, 12700 * width, 12700 * height, cell.getFirstCol(), cell.getFirstRow(), cell.getLastCol(), cell.getLastRow()));
            group.setCoordinates(0, 0, 12700 * width, 12700 * height);
            for (Line line : lineList) {
                int d;
                int x = line.getStartx() * 12700;
                int y = line.getStarty() * 12700;
                int cx = line.getEndx() * 12700;
                int cy = line.getEndy() * 12700;
                if (x > cx) {
                    d = x - cx;
                    x -= d;
                    cx -= d;
                }
                if (y > cy) {
                    d = y - cy;
                    y -= d;
                    cy -= d;
                }
                XSSFChildAnchor childAnchor = new XSSFChildAnchor(x, y, cx, cy);
                XSSFSimpleShape lineShape = group.createSimpleShape(childAnchor);
                lineShape.setShapeType(1);
                lineShape.setLineStyle(0);
                lineShape.setLineStyleColor(0, 0, 0);
            }
        }
    }

    private void createChart(SXSSFSheet sheet, ChartInfo chartInfo) {
        XSSFDrawing xssfDrawing = sheet.getDrawingPatriarch();
        if (null == xssfDrawing) {
            sheet.createDrawingPatriarch();
            xssfDrawing = sheet.getDrawingPatriarch();
        }
        RectCell location = chartInfo.getLocation();
        XSSFClientAnchor anchor = xssfDrawing.createAnchor(0, 0, 0, 0, location.getFirstCol(), location.getFirstRow(), location.getLastCol(), location.getLastRow());
        XSSFChart chart = xssfDrawing.createChart((ClientAnchor)anchor);
        BuildChartServiceImpl buildChartService = new BuildChartServiceImpl();
        switch (chartInfo.getType()) {
            case "bar": {
                buildChartService.buildBar((Chart)chart, chartInfo, sheet.getSheetName());
                break;
            }
            case "pie": {
                buildChartService.buildPie((Chart)chart, chartInfo, sheet.getSheetName());
                break;
            }
            case "bar-line": {
                buildChartService.buildBarLine((Chart)chart, chartInfo, sheet.getSheetName());
                break;
            }
            default: {
                buildChartService.buildBar((Chart)chart, chartInfo, sheet.getSheetName());
            }
        }
    }
}

