/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.sign.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.contract.api.sign.bo.ContractDelSignReqBO;
import com.tydic.contract.api.sign.bo.ContractDelSignRspBO;
import com.tydic.contract.api.sign.service.ContractDelSignService;
import com.tydic.contract.constant.Constant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractModifyApplyMapper;
import com.tydic.contract.dao.ContractTaskHisMapper;
import com.tydic.contract.po.ContractAccessoryPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractModifyApplyPO;
import com.tydic.contract.po.ContractTaskHisPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.sign.service.ContractDelSignService"})
public class ContractDelSignServiceImpl
implements ContractDelSignService {
    private static final Logger log = LoggerFactory.getLogger(ContractDelSignServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractModifyApplyMapper contractModifyApplyMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractTaskHisMapper contractTaskHisMapper;

    @PostMapping(value={"delSign"})
    public ContractDelSignRspBO delSign(@RequestBody ContractDelSignReqBO reqBO) {
        ContractDelSignRspBO rspBO = new ContractDelSignRspBO();
        List<ContractAccessoryPO> accessoryPOS = null;
        if ("1".equals(reqBO.getContractInfoType())) {
            accessoryPOS = this.contractAccessoryMapper.selectSignByContractId(reqBO.getContractId());
            ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
            log.error("\u5220\u9664\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\uff1a" + JSON.toJSONString(accessoryPOS));
            if (contractInfoPO == null) {
                rspBO.setCode("8888");
                rspBO.setMessage("\u8be5\u5408\u540c\u4e0d\u5b58\u5728\uff01");
                return rspBO;
            }
            log.error("contractInfoPO:::::" + JSON.toJSON((Object)contractInfoPO));
            if (contractInfoPO.getContractType() == Constant.CONTRACT_TYPE_ENTER) {
                rspBO.setCode("8888");
                rspBO.setMessage("\u6b64\u64cd\u4f5c\u4e0d\u9002\u7528\u5165\u9a7b\u5408\u540c\uff0c\u8bf7\u786e\u8ba4\uff01");
                return rspBO;
            }
            if (contractInfoPO.getContractStatus() != Constant.CONTRACT_STATUS_SIGNER) {
                rspBO.setCode("8888");
                rspBO.setMessage("\u5408\u540c\u72b6\u6001\u4e0d\u4e3a\u751f\u6210\u65b9\u5f85\u7b7e\u7ae0\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u786e\u8ba4\uff01");
                return rspBO;
            }
            contractInfoPO.setContractStatus(Constant.CONTRACT_STATUS_GENERATOR);
            if (!CollectionUtils.isEmpty(accessoryPOS)) {
                contractInfoPO.setContractPdfUrl(accessoryPOS.get(0).getAcceessoryUrl());
            } else {
                contractInfoPO.setContractPdfUrl(null);
            }
            this.contractInfoMapper.updateSignByContractId(contractInfoPO);
        } else {
            accessoryPOS = this.contractAccessoryMapper.selectSignByUpdateApplyId(reqBO.getContractId());
            ContractModifyApplyPO contractModifyApplyPO = this.contractModifyApplyMapper.selectByPrimaryKey(reqBO.getContractId());
            if (contractModifyApplyPO == null) {
                rspBO.setCode("8888");
                rspBO.setMessage("\u8be5\u5408\u540c\u4e0d\u5b58\u5728\uff01");
                return rspBO;
            }
            if (contractModifyApplyPO.getContractType() == Constant.CONTRACT_TYPE_ENTER) {
                rspBO.setCode("8888");
                rspBO.setMessage("\u6b64\u64cd\u4f5c\u4e0d\u9002\u7528\u5165\u9a7b\u5408\u540c\uff0c\u8bf7\u786e\u8ba4\uff01");
                return rspBO;
            }
            if (contractModifyApplyPO.getApplyStatus() != Constant.CONTRACT_STATUS_SIGNER) {
                rspBO.setCode("8888");
                rspBO.setMessage("\u5408\u540c\u72b6\u6001\u4e0d\u4e3a\u751f\u6210\u65b9\u5f85\u7b7e\u7ae0\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u786e\u8ba4\uff01");
                return rspBO;
            }
            contractModifyApplyPO.setApplyStatus(Constant.CONTRACT_STATUS_GENERATOR);
            this.contractModifyApplyMapper.updateByPrimaryKeySelective(contractModifyApplyPO);
        }
        ContractTaskHisPO contractTaskHisPO = new ContractTaskHisPO();
        contractTaskHisPO.setContractId(reqBO.getContractId());
        contractTaskHisPO.setOperName(reqBO.getName());
        contractTaskHisPO.setOperId(reqBO.getUserId());
        contractTaskHisPO.setOperOrgId(reqBO.getOrgId());
        contractTaskHisPO.setOperOrgName(reqBO.getOrgName());
        contractTaskHisPO.setArrivalTime(new Date());
        contractTaskHisPO.setOperateTime(new Date());
        contractTaskHisPO.setBusiStep(Constant.CONTRACT_STEP_APPLY);
        contractTaskHisPO.setBusiStepName("\u5220\u9664PDF\u5408\u540c");
        contractTaskHisPO.setRemark("\u5220\u9664PDF\u5408\u540c");
        contractTaskHisPO.setOperateBehavior("\u5220\u9664\u5408\u540c");
        contractTaskHisPO.setRoleName("\u5408\u540c\u7ba1\u7406\u5458");
        this.contractTaskHisMapper.insertSelective(contractTaskHisPO);
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        log.error("rspBO:::::::::::::" + rspBO);
        return rspBO;
    }
}

