/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.maintenance.busi.impl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleReqBO;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleRspBO;
import com.tydic.contract.api.maintenance.service.QryContractSupplierListSaleService;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractSupplierSaleMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractSupplierSalePO;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.maintenance.service.QryContractSupplierListSaleService"})
public class QryContractSupplierListSaleServiceImpl
implements QryContractSupplierListSaleService {
    private static final Logger log = LoggerFactory.getLogger(QryContractSupplierListSaleServiceImpl.class);
    @Autowired
    private ContractSupplierSaleMapper contractSupplierSaleMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @PostMapping(value={"selecContractSupplierList"})
    public RspPage<ContractSupplierSaleRspBO> selecContractSupplierList(@RequestBody ContractSupplierSaleReqBO contractSupplierSaleReqBO) {
        RspPage rspPage = new RspPage();
        try {
            Page page = new Page(contractSupplierSaleReqBO.getPageNo(), contractSupplierSaleReqBO.getPageSize());
            ContractSupplierSalePO contractSupplierSalePO = new ContractSupplierSalePO();
            BeanUtils.copyProperties((Object)contractSupplierSaleReqBO, (Object)contractSupplierSalePO);
            List<ContractSupplierSalePO> contractSupplierSalePOs = this.contractSupplierSaleMapper.selectPageListSelective(contractSupplierSalePO, (Page<ContractSupplierSalePO>)page);
            if (contractSupplierSalePOs != null && contractSupplierSalePOs.size() > 0) {
                List contractSupplierSaleRspBOs = contractSupplierSalePOs.stream().map(contractSupplierSale -> {
                    ContractSupplierSaleRspBO contractSupplierSaleRspBO = new ContractSupplierSaleRspBO();
                    BeanUtils.copyProperties((Object)contractSupplierSale, (Object)contractSupplierSaleRspBO);
                    Integer rateFee = contractSupplierSale.getRateFee();
                    DecimalFormat df = new DecimalFormat("0.00");
                    String rateFeeS = df.format((float)rateFee.intValue() / 100.0f);
                    contractSupplierSaleRspBO.setRateFee(new BigDecimal(rateFeeS));
                    Integer discount = contractSupplierSale.getDiscount();
                    String discountS = df.format((float)discount.intValue() / 100.0f);
                    contractSupplierSaleRspBO.setDiscount(new BigDecimal(discountS));
                    return contractSupplierSaleRspBO;
                }).collect(Collectors.toList());
                rspPage.setPageNo(page.getPageNo());
                rspPage.setRows(contractSupplierSaleRspBOs);
                rspPage.setTotal(page.getTotalPages());
                rspPage.setRecordsTotal(page.getTotalCount());
                rspPage.setCode("0000");
                rspPage.setMessage("\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4f9b\u8d27\u55461\u9500\u552e\u54c1\u7c7b\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u4f9b\u8d27\u55461\u9500\u552e\u54c1\u7c7b\u5217\u8868\u5931\u8d25");
        }
        return rspPage;
    }

    @PostMapping(value={"selecContractSupplierListByEnterPurchaserId"})
    public List<ContractSupplierSaleRspBO> selecContractSupplierListByEnterPurchaserId(@RequestBody ContractSupplierSaleReqBO contractSupplierSaleReqBO) {
        ArrayList<ContractSupplierSaleRspBO> contractSupplierSaleRspBOs = new ArrayList<ContractSupplierSaleRspBO>();
        try {
            ContractInfoPO po = new ContractInfoPO();
            BeanUtils.copyProperties((Object)contractSupplierSaleReqBO, (Object)po);
            po.setValidStatus(1);
            ContractInfoPO poo = this.contractInfoMapper.selectByPrimaryKey(contractSupplierSaleReqBO.getContractId());
            Long contratcId = null;
            if (poo == null) {
                return contractSupplierSaleRspBOs;
            }
            contratcId = poo.getContractId();
            contractSupplierSaleReqBO.setContractId(contratcId);
            ContractSupplierSalePO contractSupplierSalePO = new ContractSupplierSalePO();
            BeanUtils.copyProperties((Object)contractSupplierSaleReqBO, (Object)contractSupplierSalePO);
            List<ContractSupplierSalePO> contractSupplierSalePOs = this.contractSupplierSaleMapper.selectPageListSelectiveNoPage(contractSupplierSalePO);
            if (contractSupplierSalePOs != null && contractSupplierSalePOs.size() > 0) {
                for (ContractSupplierSalePO contractSupplierSale : contractSupplierSalePOs) {
                    ContractSupplierSaleRspBO contractSupplierSaleRspBO = new ContractSupplierSaleRspBO();
                    BeanUtils.copyProperties((Object)contractSupplierSale, (Object)contractSupplierSaleRspBO);
                    Integer rateFee = contractSupplierSale.getRateFee();
                    DecimalFormat df = new DecimalFormat("0.00");
                    String rateFeeS = df.format((float)rateFee.intValue() / 100.0f);
                    contractSupplierSaleRspBO.setRateFee(new BigDecimal(rateFeeS));
                    Integer discount = contractSupplierSale.getDiscount();
                    String discountS = df.format((float)discount.intValue() / 100.0f);
                    contractSupplierSaleRspBO.setDiscount(new BigDecimal(discountS));
                    contractSupplierSaleRspBOs.add(contractSupplierSaleRspBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u4f9b\u8d27\u55461\u9500\u552e\u54c1\u7c7b\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u67e5\u8be2\u4f9b\u8d27\u55461\u9500\u552e\u54c1\u7c7b\u5217\u8868\u5931\u8d25");
        }
        return contractSupplierSaleRspBOs;
    }
}

