/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.order.busi.impl;

import com.tydic.contract.api.order.bo.SequenceContractReq;
import com.tydic.contract.api.order.service.SequenceContractService;
import com.tydic.contract.dao.SequenceMapper;
import com.tydic.contract.po.SequencePO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.order.service.SequenceContractService"})
public class SequenceContractServiceImpl
implements SequenceContractService {
    private static final String STR_FORMAT_SIX = "000000";
    private static final String STR_FORMAT_THREE = "000";
    private static final String STR_FORMAT_TWO = "00";
    @Autowired
    private SequenceMapper sequenceMapper;

    @PostMapping(value={"getSequenceId"})
    public String getSequenceId(@RequestBody SequenceContractReq sequenceContractReq) {
        String seqNum = null;
        if (1 == sequenceContractReq.getType()) {
            Long seqId = this.sequenceMapper.selectValue(sequenceContractReq.getSeqName());
            this.sequenceMapper.updateValue(sequenceContractReq.getSeqName());
            seqNum = SequenceContractServiceImpl.leftFormatSix(seqId);
        } else if (2 == sequenceContractReq.getType()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String s = sdf.format(new Date());
            Date date2 = null;
            try {
                date2 = sdf.parse(s);
                System.out.println(sdf.format(date2));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SequencePO sequencePO = new SequencePO();
            sequencePO.setCreateTime(date2);
            sequencePO.setSeqName(sequenceContractReq.getSeqName());
            SequencePO sequencePO1 = this.sequenceMapper.selectByCreateTime(sequencePO);
            if (sequencePO1 != null && sequencePO1.getCurrentValue() != null) {
                this.sequenceMapper.updateValue(sequenceContractReq.getSeqName());
                seqNum = SequenceContractServiceImpl.leftFormatThree(sequencePO1.getCurrentValue());
            } else {
                SequencePO sequencePO2 = new SequencePO();
                sequencePO2.setSeqName(sequenceContractReq.getSeqName());
                sequencePO2.setCreateTime(date2);
                sequencePO2.setCurrentValue(1L);
                this.sequenceMapper.updateValue1(sequencePO2);
                Long seqId = this.sequenceMapper.selectValue(sequenceContractReq.getSeqName());
                this.sequenceMapper.updateValue(sequenceContractReq.getSeqName());
                seqNum = SequenceContractServiceImpl.leftFormatThree(seqId);
            }
        } else if (3 == sequenceContractReq.getType()) {
            Random random = new Random();
            int ends = random.nextInt(99);
            seqNum = String.format("%02d", ends);
        }
        return seqNum;
    }

    public static String leftFormatSix(Long num) {
        String zeroStr = STR_FORMAT_SIX;
        String numStr = String.valueOf(num);
        zeroStr = zeroStr.substring(0, zeroStr.length() - numStr.length());
        return zeroStr + numStr;
    }

    public static String leftFormatThree(Long num) {
        String zeroStr = STR_FORMAT_THREE;
        String numStr = String.valueOf(num);
        zeroStr = zeroStr.substring(0, zeroStr.length() - numStr.length());
        return zeroStr + numStr;
    }

    public static String leftFormatTwo(Long num) {
        String zeroStr = STR_FORMAT_TWO;
        String numStr = String.valueOf(num);
        zeroStr = zeroStr.substring(0, zeroStr.length() - numStr.length());
        return zeroStr + numStr;
    }
}

