/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.order.busi.impl;

import com.tydic.contract.api.order.bo.ApprovalContractCreateReqBO;
import com.tydic.contract.api.order.bo.ApprovalContractCreateRspBO;
import com.tydic.contract.api.order.service.ApprovalContractCreateService;
import com.tydic.contract.constant.Constant;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractTaskHisMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractTaskHisPO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.exception.BusinessException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.order.service.ApprovalContractCreateService"})
public class ApprovalContractCreateServiceImpl
implements ApprovalContractCreateService {
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractTaskHisMapper contractTaskHisMapper;

    @PostMapping(value={"approvalContractCreate"})
    public ApprovalContractCreateRspBO approvalContractCreate(@RequestBody ApprovalContractCreateReqBO approvalContractCreateReqBO) {
        ApprovalContractCreateRspBO approvalContractCreateRspBO = new ApprovalContractCreateRspBO();
        UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        if (StringUtils.isNotBlank((String)approvalContractCreateReqBO.getStepId())) {
            uacNoTaskAuditOrderAuditReqBO.setStepId(approvalContractCreateReqBO.getStepId());
        }
        if (approvalContractCreateReqBO.getStepId() == null) {
            throw new BusinessException("8888", "\u5ba1\u6279\u5df2\u7ed3\u675f");
        }
        uacNoTaskAuditOrderAuditReqBO.setAuditResult(approvalContractCreateReqBO.getAuditResult());
        uacNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(approvalContractCreateReqBO.getUserId()));
        uacNoTaskAuditOrderAuditReqBO.setUsername(approvalContractCreateReqBO.getName());
        uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(approvalContractCreateReqBO.getAuditAdvice());
        uacNoTaskAuditOrderAuditReqBO.setObjType(Integer.valueOf(1));
        uacNoTaskAuditOrderAuditReqBO.setObjId(approvalContractCreateReqBO.getContractId());
        UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
        if (!uacNoTaskAuditOrderAuditRspBO.getRespCode().equals("0000")) {
            throw new BusinessException("8888", "\u5ba1\u6279\u5931\u8d25" + uacNoTaskAuditOrderAuditRspBO.getRespCode());
        }
        Integer contractStatus = null;
        if (approvalContractCreateReqBO.getAuditResult() == 0) {
            contractStatus = Constant.CONTRACT_STATUS_PASS;
        } else if (1 == approvalContractCreateReqBO.getAuditResult()) {
            contractStatus = Constant.CONTRACT_STATUS_REJECT;
        }
        for (Long contractId : approvalContractCreateReqBO.getContractId()) {
            ContractInfoPO contractInfoPO = new ContractInfoPO();
            contractInfoPO.setContractId(contractId);
            contractInfoPO.setContractStatus(contractStatus);
            this.contractInfoMapper.updateByContractID(contractInfoPO);
            ContractTaskHisPO contractTaskHisPO = new ContractTaskHisPO();
            contractTaskHisPO.setContractId(contractId);
            contractTaskHisPO.setOperName(approvalContractCreateReqBO.getName());
            contractTaskHisPO.setOperId(approvalContractCreateReqBO.getUserId());
            contractTaskHisPO.setOperOrgId(approvalContractCreateReqBO.getOrgId());
            contractTaskHisPO.setOperOrgName(approvalContractCreateReqBO.getOrgName());
            contractTaskHisPO.setArrivalTime(new Date());
            contractTaskHisPO.setOperateTime(new Date());
            contractTaskHisPO.setBusiStep(Constant.CONTRACT_STEP_APPLY);
            contractTaskHisPO.setBusiStepName("\u5ba1\u6279\u5408\u540c");
            contractTaskHisPO.setRemark(approvalContractCreateReqBO.getAuditAdvice());
            if (approvalContractCreateReqBO.getAuditResult() == 0) {
                contractTaskHisPO.setOperateBehavior("\u901a\u8fc7");
            } else if (1 == approvalContractCreateReqBO.getAuditResult()) {
                contractTaskHisPO.setOperateBehavior("\u9a73\u56de");
            }
            contractTaskHisPO.setRoleName("\u5408\u540c\u5ba1\u6279\u5c97");
            this.contractTaskHisMapper.insertSelective(contractTaskHisPO);
        }
        approvalContractCreateRspBO.setCode("0000");
        approvalContractCreateRspBO.setMessage("\u6210\u529f");
        return approvalContractCreateRspBO;
    }
}

