/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.agreement.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.api.agreement.bo.ContractAgreementCreateReqBO;
import com.tydic.contract.api.agreement.bo.ContractAgreementCreateRspBO;
import com.tydic.contract.api.agreement.bo.QueryAgreementContractItemReqBO;
import com.tydic.contract.api.agreement.service.ContractAgreementCreateService;
import com.tydic.contract.api.order.bo.ContractAccessoryReqBO;
import com.tydic.contract.constant.Constant;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractTaskHisMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.ContractAccessoryPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractTaskHisPO;
import com.tydic.contract.po.ContractTermsPO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.agreement.service.ContractAgreementCreateService"})
public class ContractAgreementCreateServiceImpl
implements ContractAgreementCreateService {
    private static final Logger log = LoggerFactory.getLogger(ContractAgreementCreateServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private ContractTermsMapper contractTermsMapper;
    @Autowired
    private ContractTaskHisMapper contractTaskHisMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;

    @PostMapping(value={"agreementCreate"})
    public ContractAgreementCreateRspBO agreementCreate(@RequestBody ContractAgreementCreateReqBO contractAgreementCreateReqBO) {
        ContractAgreementCreateRspBO contractAgreementCreateRspBO = new ContractAgreementCreateRspBO();
        if (contractAgreementCreateReqBO.getContractId() == null && contractAgreementCreateReqBO.getSaveOrSubmit() == Constant.CONTRACT_SAVE) {
            ContractInfoPO contractInfoPO = new ContractInfoPO();
            contractInfoPO.setAgreementId(contractAgreementCreateReqBO.getAgreementId());
            contractInfoPO.setValidStatus(Constant.VALID_STATUS_YES);
            contractInfoPO.setContractType(contractAgreementCreateReqBO.getContractType());
            int check = this.contractInfoMapper.getCheckBy(contractInfoPO);
            if (check > 1) {
                contractAgreementCreateRspBO.setCode("8888");
                contractAgreementCreateRspBO.setMessage("\u534f\u8bae\u5408\u540c\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u521b\u5efa");
                return contractAgreementCreateRspBO;
            }
        }
        String contractCode = contractAgreementCreateReqBO.getContractCodeRule() + "-" + contractAgreementCreateReqBO.getContractCodeVar();
        if (contractAgreementCreateReqBO.getContractCode() != null) {
            ContractInfoPO contractInfoPO = new ContractInfoPO();
            contractInfoPO.setValidStatus(Constant.VALID_STATUS_YES);
            contractInfoPO.setContractCode(contractCode);
            int check = this.contractInfoMapper.getCheckBy(contractInfoPO);
            if (check > 1) {
                contractAgreementCreateRspBO.setCode("7777");
                contractAgreementCreateRspBO.setMessage("\u6846\u67b6\u534f\u8bae\u5408\u540c\u7f16\u53f7\u5df2\u5b58\u5728");
                return contractAgreementCreateRspBO;
            }
        }
        Long contrantId = Sequence.getInstance().nextId();
        if (contractAgreementCreateReqBO.getSaveOrSubmit() == Constant.CONTRACT_SAVE) {
            ContractInfoPO contractInfoPO = new ContractInfoPO();
            BeanUtils.copyProperties((Object)contractAgreementCreateReqBO, (Object)contractInfoPO);
            contractInfoPO.setContractCode(contractCode);
            contractInfoPO.setContractStatus(Constant.CONTRACT_DRAFT_STATUS);
            contractInfoPO.setValidStatus(Constant.VALID_STATUS_YES);
            contractInfoPO.setCreateTime(new Date());
            contractInfoPO.setPurchaserId(Long.valueOf(contractAgreementCreateReqBO.getPurchaserId()));
            contractInfoPO.setAgreementName(contractAgreementCreateReqBO.getAgreementTypeStr());
            contractInfoPO.setAgreementType(contractAgreementCreateReqBO.getAgreementType());
            contractInfoPO.setQuaAmount(contractAgreementCreateReqBO.getQuaPay());
            contractInfoPO.setSupplierId(Long.valueOf(contractAgreementCreateReqBO.getSupplierId()));
            contractInfoPO.setAgreementMode(contractAgreementCreateReqBO.getAgreementMode());
            contractInfoPO.setUpdateTime(new Date());
            contractInfoPO.setUpdateUserId(contractAgreementCreateReqBO.getUserId());
            contractInfoPO.setUpdateUserName(contractAgreementCreateReqBO.getName());
            log.error("\u5408\u540cId" + contrantId);
            contractInfoPO.setContractId(contrantId);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (!StringUtils.isBlank((String)contractAgreementCreateReqBO.getSignDate())) {
                Date parse = null;
                try {
                    parse = sdf.parse(contractAgreementCreateReqBO.getSignDate());
                }
                catch (ParseException e) {
                    log.error("\u7b7e\u8ba2\u65f6\u95f4\u683c\u5f0f\u9519\u8bef", (Throwable)e);
                }
                contractInfoPO.setSignDate(parse);
            }
            ContractTermsPO contractTermsPO = this.contractTermsMapper.selectByPrimaryKey(contractAgreementCreateReqBO.getContractTermId());
            contractInfoPO.setContractTermText(contractTermsPO.getTermText());
            this.contractInfoMapper.insertSelective(contractInfoPO);
            if (contractAgreementCreateReqBO.getQueryAgreementContractItemReqBOList() != null && contractAgreementCreateReqBO.getQueryAgreementContractItemReqBOList().size() > 0) {
                for (QueryAgreementContractItemReqBO queryAgreementContractItemReqBO : contractAgreementCreateReqBO.getQueryAgreementContractItemReqBOList()) {
                    ContractInfoItemPO contractInfoItemPO = new ContractInfoItemPO();
                    contractInfoItemPO.setAgreementName(queryAgreementContractItemReqBO.getAgreementName());
                    contractInfoItemPO.setAgreementId(contractAgreementCreateReqBO.getAgreementId());
                    contractInfoItemPO.setContractId(contrantId);
                    contractInfoItemPO.setContractCode(contractCode);
                    contractInfoItemPO.setContractName(contractAgreementCreateReqBO.getContractName());
                    contractInfoItemPO.setContractType(contractAgreementCreateReqBO.getContractType());
                    contractInfoItemPO.setMaterialClassId(queryAgreementContractItemReqBO.getCatalogName());
                    contractInfoItemPO.setMaterialCode(queryAgreementContractItemReqBO.getMaterialId());
                    contractInfoItemPO.setMaterialName(queryAgreementContractItemReqBO.getMaterialName());
                    contractInfoItemPO.setPlaAgreementCode(queryAgreementContractItemReqBO.getPlaAgreementCode());
                    contractInfoItemPO.setEntAgreementCode(queryAgreementContractItemReqBO.getEntAgreementCode());
                    contractInfoItemPO.setAgreementType((int)contractAgreementCreateReqBO.getAgreementType());
                    contractInfoItemPO.setModel(queryAgreementContractItemReqBO.getModel());
                    contractInfoItemPO.setSpec(queryAgreementContractItemReqBO.getSpec());
                    contractInfoItemPO.setFigureNo(queryAgreementContractItemReqBO.getFigure());
                    contractInfoItemPO.setMaterialsQuality(queryAgreementContractItemReqBO.getTexture());
                    contractInfoItemPO.setBrand(queryAgreementContractItemReqBO.getBrandName());
                    contractInfoItemPO.setManufacturer(queryAgreementContractItemReqBO.getManufacturer());
                    contractInfoItemPO.setRequireDateText(queryAgreementContractItemReqBO.getSupplyCycle().toString());
                    contractInfoItemPO.setUnitName(queryAgreementContractItemReqBO.getMeasureName());
                    contractInfoItemPO.setOrderPrice(queryAgreementContractItemReqBO.getSalePrice());
                    contractInfoItemPO.setOrderAmount(queryAgreementContractItemReqBO.getSalePriceSum());
                    contractInfoItemPO.setBuyCount(queryAgreementContractItemReqBO.getBuyNumber());
                    contractInfoItemPO.setCreateTime(new Date());
                    contractInfoItemPO.setValidDate(1);
                    contractInfoItemPO.setEcpAgreementCode(contractAgreementCreateReqBO.getEcpAgreementCode());
                    this.contractInfoItemMapper.insertSelective(contractInfoItemPO);
                }
            }
            if (contractAgreementCreateReqBO.getContractAccessoryList() != null && contractAgreementCreateReqBO.getContractAccessoryList().size() > 0) {
                for (ContractAccessoryReqBO contractAccessoryReqBO : contractAgreementCreateReqBO.getContractAccessoryList()) {
                    ContractAccessoryPO contractAccessoryPO = new ContractAccessoryPO();
                    contractAccessoryPO.setAcceessoryName(contractAccessoryReqBO.getAcceessoryName());
                    contractAccessoryPO.setContractId(contrantId);
                    contractAccessoryPO.setContractType(contractAgreementCreateReqBO.getContractType());
                    contractAccessoryPO.setCreateTime(new Date());
                    contractAccessoryPO.setValidStatus(Constant.VALID_STATUS_YES);
                    contractAccessoryPO.setAcceessoryUrl(contractAccessoryReqBO.getAcceessoryUrl());
                    contractAccessoryPO.setAcceessoryType(Constant.ACCEESSORY_TYPE_1);
                    this.contractAccessoryMapper.insertSelective(contractAccessoryPO);
                }
            }
            ContractTaskHisPO contractTaskHisPO = new ContractTaskHisPO();
            contractTaskHisPO.setContractId(contrantId);
            contractTaskHisPO.setOperName(contractAgreementCreateReqBO.getName());
            contractTaskHisPO.setOperId(contractAgreementCreateReqBO.getUserId());
            contractTaskHisPO.setOperOrgId(contractAgreementCreateReqBO.getOrgId());
            contractTaskHisPO.setOperOrgName(contractAgreementCreateReqBO.getOrgName());
            contractTaskHisPO.setArrivalTime(new Date());
            contractTaskHisPO.setOperateTime(new Date());
            contractTaskHisPO.setBusiStep(Constant.CONTRACT_STEP_CREATE);
            contractTaskHisPO.setBusiStepName("\u521b\u5efa\u8349\u7a3f");
            contractTaskHisPO.setOperateBehavior("\u521b\u5efa\u8349\u7a3f");
            contractTaskHisPO.setRoleName("\u5408\u540c\u7ba1\u7406\u5458");
            this.contractTaskHisMapper.insertSelective(contractTaskHisPO);
        } else if (contractAgreementCreateReqBO.getSaveOrSubmit() == Constant.CONTRACT_SUBMIT) {
            // empty if block
        }
        contractAgreementCreateRspBO.setContractId(contrantId);
        contractAgreementCreateRspBO.setContractCode(contractCode);
        contractAgreementCreateRspBO.setCode("0000");
        contractAgreementCreateRspBO.setMessage("\u65b0\u589e\u6210\u529f");
        return contractAgreementCreateRspBO;
    }
}

