/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.order.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.order.bo.ContractOrderInfoBO;
import com.tydic.contract.api.order.bo.QueryContractOrderReqBO;
import com.tydic.contract.api.order.bo.QueryContractOrderRspBO;
import com.tydic.contract.api.order.service.QryContractOrderWaitApplyService;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.order.service.QryContractOrderWaitApplyService"})
public class QryContractOrderWaitApplyServiceImpl
implements QryContractOrderWaitApplyService {
    private static final Logger log = LoggerFactory.getLogger(QryContractOrderWaitApplyServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @PostMapping(value={"queryContractOrderWaitApplyNoPage"})
    public QueryContractOrderRspBO queryContractOrderWaitApplyNoPage(@RequestBody QueryContractOrderReqBO queryContractOrderReqBO) {
        log.info("\u8c03\u7528queryContractOrderNoPage\u65b9\u6cd5[\u5165\u53c2req]={}" + queryContractOrderReqBO.toString());
        QueryContractOrderRspBO queryContractOrderRspBO = new QueryContractOrderRspBO();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("purchaseOrderCode", queryContractOrderReqBO.getPurchaseOrderCode());
        map.put("createUserName", queryContractOrderReqBO.getCreateUserName());
        map.put("contractCode", queryContractOrderReqBO.getContractCode());
        map.put("contractName", queryContractOrderReqBO.getContractName());
        map.put("contractType", queryContractOrderReqBO.getContractType());
        map.put("supplierId", queryContractOrderReqBO.getSupplierId());
        map.put("beginDate", queryContractOrderReqBO.getBeginDate());
        map.put("endDate", queryContractOrderReqBO.getEndDate());
        map.put("minAmount", queryContractOrderReqBO.getMinAmount());
        map.put("maxAmount", queryContractOrderReqBO.getMaxAmount());
        map.put("contractStatus", queryContractOrderReqBO.getContractStatus());
        log.info("queryModifyContractApplyListNoPage::map=" + ((Object)map).toString());
        List<ContractInfoPO> orderList = this.contractInfoMapper.searchNoApplyOrderList(map);
        if (!CollectionUtils.isEmpty(orderList)) {
            List contractOrderInfoBOs = orderList.stream().map(e -> {
                ContractOrderInfoBO enterFormBO = new ContractOrderInfoBO();
                BeanUtils.copyProperties((Object)e, (Object)enterFormBO);
                return enterFormBO;
            }).collect(Collectors.toList());
            queryContractOrderRspBO.setRows(contractOrderInfoBOs);
        }
        queryContractOrderRspBO.setRespCode("0000");
        queryContractOrderRspBO.setRespDesc("\u6210\u529f");
        log.info("queryContractOrderRspBO=" + queryContractOrderRspBO.toString());
        return queryContractOrderRspBO;
    }

    @PostMapping(value={"queryContractOrderWaitApplyPage"})
    public QueryContractOrderRspBO queryContractOrderWaitApplyPage(@RequestBody QueryContractOrderReqBO queryContractOrderReqBO) {
        log.info("\u8c03\u7528queryContractOrderPage\u65b9\u6cd5[\u5165\u53c2req]={}" + queryContractOrderReqBO.toString());
        Page page = new Page(queryContractOrderReqBO.getPageNo(), queryContractOrderReqBO.getPageSize());
        QueryContractOrderRspBO queryContractOrderRspBO = new QueryContractOrderRspBO();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("purchaseOrderCode", queryContractOrderReqBO.getPurchaseOrderCode());
        map.put("createUserName", queryContractOrderReqBO.getCreateUserName());
        map.put("contractCode", queryContractOrderReqBO.getContractCode());
        map.put("contractName", queryContractOrderReqBO.getContractName());
        map.put("contractType", queryContractOrderReqBO.getContractType());
        map.put("supplierId", queryContractOrderReqBO.getSupplierId());
        map.put("beginDate", queryContractOrderReqBO.getBeginDate());
        map.put("endDate", queryContractOrderReqBO.getEndDate());
        map.put("minAmount", queryContractOrderReqBO.getMinAmount());
        map.put("maxAmount", queryContractOrderReqBO.getMaxAmount());
        map.put("contractStatus", queryContractOrderReqBO.getContractStatus());
        log.info("queryContractOrderPage::map=" + ((Object)map).toString());
        List<ContractInfoPO> orderList = this.contractInfoMapper.searchNoApplyOrderListPage(map, (Page<Map<String, Object>>)page);
        if (!CollectionUtils.isEmpty(orderList)) {
            List contractOrderInfoBOs = orderList.stream().map(e -> {
                ContractOrderInfoBO enterFormBO = new ContractOrderInfoBO();
                BeanUtils.copyProperties((Object)e, (Object)enterFormBO);
                return enterFormBO;
            }).collect(Collectors.toList());
            queryContractOrderRspBO.setRows(contractOrderInfoBOs);
        }
        queryContractOrderRspBO.setRespCode("0000");
        queryContractOrderRspBO.setRespDesc("\u6210\u529f");
        queryContractOrderRspBO.setTotal(page.getTotalPages());
        queryContractOrderRspBO.setRecordsTotal(page.getTotalCount());
        log.info("queryContractOrderPage::queryContractOrderRspBO=" + queryContractOrderRspBO.toString());
        return queryContractOrderRspBO;
    }
}

