/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.supplier.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.supplier.bo.ContractSupplierSaleBO;
import com.tydic.contract.api.supplier.bo.QuerySupplierByCategoryIdReqBO;
import com.tydic.contract.api.supplier.bo.QuerySupplierByCategoryIdRspBO;
import com.tydic.contract.api.supplier.service.QuerySupplierByCategoryIdService;
import com.tydic.contract.dao.ContractSupplierSaleMapper;
import com.tydic.contract.po.ContractSupplierSalePO;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.supplier.service.QuerySupplierByCategoryIdService"})
public class QuerySupplierByCategoryIdServiceImpl
implements QuerySupplierByCategoryIdService {
    private static final Logger log = LoggerFactory.getLogger(QuerySupplierByCategoryIdServiceImpl.class);
    @Autowired
    private ContractSupplierSaleMapper contractSupplierSaleMapper;

    @PostMapping(value={"querySupplierByCategoryId"})
    public QuerySupplierByCategoryIdRspBO querySupplierByCategoryId(@RequestBody QuerySupplierByCategoryIdReqBO reqBO) {
        QuerySupplierByCategoryIdRspBO rspBO = new QuerySupplierByCategoryIdRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getCategoryIds())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u7269\u6599\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546API\u5165\u53c2\u7c7b\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ContractSupplierSalePO salePO = new ContractSupplierSalePO();
        salePO.setCategoryIds(reqBO.getCategoryIds());
        salePO.setEnterPurchaserName(reqBO.getEnterPurchaserName());
        salePO.setDistributionGoodsType(reqBO.getDistributionGoodsType());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ContractSupplierSalePO> pageResult = this.contractSupplierSaleMapper.querySupplierByCategoryId(salePO, (Page<ContractSupplierSalePO>)page);
        if (CollectionUtils.isEmpty(pageResult)) {
            rspBO.setCode("0000");
            rspBO.setMessage("\u6210\u529f");
            return rspBO;
        }
        ArrayList<Long> enterPurchaserIdList = new ArrayList<Long>();
        pageResult.forEach(po -> enterPurchaserIdList.add(po.getEnterPurchaserId()));
        salePO.setEnterPurchaserIdList(enterPurchaserIdList);
        List<ContractSupplierSalePO> resultPO = this.contractSupplierSaleMapper.querySupplierAndSaleByCategoryId(salePO);
        if (!CollectionUtils.isEmpty(resultPO)) {
            ArrayList<String> supplierIdList = new ArrayList<String>();
            HashMap<String, String> supplierInfoMap = new HashMap<String, String>();
            ArrayList<ContractSupplierSaleBO> contractSupplierSaleList = new ArrayList<ContractSupplierSaleBO>();
            Map<Long, List<ContractSupplierSalePO>> relationMap = resultPO.stream().collect(Collectors.groupingBy(ContractSupplierSalePO::getEnterPurchaserId));
            for (Map.Entry<Long, List<ContractSupplierSalePO>> entry : relationMap.entrySet()) {
                supplierIdList.add(entry.getKey().toString());
                supplierInfoMap.put(entry.getKey().toString(), entry.getValue().get(0).getEnterPurchaserName());
                ContractSupplierSaleBO saleBO = new ContractSupplierSaleBO();
                ArrayList<Long> categoryIds = new ArrayList<Long>();
                saleBO.setEnterPurchaserId(entry.getKey().toString());
                saleBO.setEnterPurchaserName(entry.getValue().get(0).getEnterPurchaserName());
                for (ContractSupplierSalePO contractSupplierSalePO : entry.getValue()) {
                    categoryIds.add(contractSupplierSalePO.getCategoryId());
                }
                saleBO.setCategoryIds(categoryIds);
                saleBO.setOverRate(categoryIds.size() + "/" + reqBO.getCategoryIds().size());
                contractSupplierSaleList.add(saleBO);
            }
            rspBO.setRows(contractSupplierSaleList);
            rspBO.setSupplierIdList(supplierIdList);
            rspBO.setSupplierInfoMap(supplierInfoMap);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"queryContractByCategoryId"})
    public QuerySupplierByCategoryIdRspBO queryContractByCategoryId(@RequestBody QuerySupplierByCategoryIdReqBO reqBO) {
        QuerySupplierByCategoryIdRspBO rspBO = new QuerySupplierByCategoryIdRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getCategoryIds()) && CollectionUtils.isEmpty((Collection)reqBO.getThirdCatalogIds())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u7269\u6599\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546API\u5165\u53c2\u7c7b\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList<ContractSupplierSaleBO> contractSupplierSaleBOS = new ArrayList<ContractSupplierSaleBO>();
        ContractSupplierSalePO salePO = new ContractSupplierSalePO();
        salePO.setCategoryIds(reqBO.getCategoryIds());
        salePO.setEnterPurchaserName(reqBO.getEnterPurchaserName());
        salePO.setDistributionGoodsType(reqBO.getDistributionGoodsType());
        salePO.setThirdCatalogIds(reqBO.getThirdCatalogIds());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ContractSupplierSalePO> pageResult = this.contractSupplierSaleMapper.queryContractIdByCategoryId(salePO, (Page<ContractSupplierSalePO>)page);
        if (!CollectionUtils.isEmpty(pageResult)) {
            for (ContractSupplierSalePO supplierSalePO : pageResult) {
                ContractSupplierSaleBO contractSupplierSaleBO = new ContractSupplierSaleBO();
                contractSupplierSaleBO.setContactId(supplierSalePO.getContractId());
                contractSupplierSaleBO.setDistributionGoodsType(supplierSalePO.getDistributionGoodsType());
                contractSupplierSaleBO.setEnterPurchaserId(supplierSalePO.getEnterPurchaserId().toString());
                contractSupplierSaleBO.setEnterPurchaserName(supplierSalePO.getEnterPurchaserName());
                contractSupplierSaleBO.setFixedCommodity(supplierSalePO.getFixedCommodity());
                contractSupplierSaleBO.setEcpProjectId(supplierSalePO.getEcpProjectId());
                contractSupplierSaleBO.setEcpProjectName(supplierSalePO.getEcpProjectName());
                contractSupplierSaleBO.setThirdCatalogId(supplierSalePO.getThirdCatalogId());
                contractSupplierSaleBOS.add(contractSupplierSaleBO);
            }
        }
        rspBO.setRows(contractSupplierSaleBOS);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setCode("0000");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }
}

