/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.template.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.template.bo.ContractTemplateConfigBO;
import com.tydic.contract.api.template.bo.ContractTemplateConfigReqBO;
import com.tydic.contract.api.template.bo.ContractTemplateConfigRspBO;
import com.tydic.contract.api.template.service.QueryContractTemplateService;
import com.tydic.contract.constant.Constant;
import com.tydic.contract.dao.ContractTemplateConfigMapper;
import com.tydic.contract.po.ContractTemplateConfigPO;
import com.tydic.contract.po.ContractTemplateConfigQueryPO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.template.service.QueryContractTemplateService"})
public class QueryContractTemplateServiceImpl
implements QueryContractTemplateService {
    private static final Logger log = LoggerFactory.getLogger(QueryContractTemplateServiceImpl.class);
    @Resource
    private ContractTemplateConfigMapper contractTemplateConfigMapper;

    @PostMapping(value={"selectPage"})
    public ContractTemplateConfigRspBO selectPage(@RequestBody ContractTemplateConfigReqBO reqBO) {
        ContractTemplateConfigRspBO rspBO = new ContractTemplateConfigRspBO();
        try {
            Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            ContractTemplateConfigQueryPO po = new ContractTemplateConfigQueryPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)po);
            List<ContractTemplateConfigPO> list = this.contractTemplateConfigMapper.selectPage(po, (Page<ContractTemplateConfigPO>)page);
            if (CollectionUtils.isEmpty(list)) {
                rspBO.setCode("0000");
                rspBO.setMessage("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                return rspBO;
            }
            ArrayList<ContractTemplateConfigBO> boList = new ArrayList<ContractTemplateConfigBO>();
            for (ContractTemplateConfigPO item : list) {
                ContractTemplateConfigBO bo = new ContractTemplateConfigBO();
                BeanUtils.copyProperties((Object)item, (Object)bo);
                if (null != bo.getTemplateType()) {
                    Integer templateType = bo.getTemplateType();
                    if (Constant.TERMS_TYPE_ORDER == templateType) {
                        bo.setTemplateTypeStr("\u91c7\u8d2d\u8ba2\u5355\u5408\u540c");
                        bo.setSupplierTypeStr("-");
                    } else if (Constant.TERMS_TYPE_AGREEMENT == templateType) {
                        bo.setTemplateTypeStr("\u6846\u67b6\u534f\u8bae\u5408\u540c");
                        bo.setSupplierTypeStr("-");
                    } else if (Constant.TERMS_TYPE_SUPPLIER == templateType) {
                        bo.setTemplateTypeStr("\u5165\u9a7b\u670d\u52a1\u5408\u540c");
                        if (null != bo.getSupplierType()) {
                            Integer supplierType = bo.getSupplierType();
                            if (Constant.SUPPLIER_TYPE_CUST == supplierType) {
                                bo.setSupplierTypeStr("\u4f9b\u5e94\u5546");
                            } else if (Constant.TERMS_TYPE_AGREEMENT == supplierType) {
                                bo.setSupplierTypeStr("\u91c7\u8d2d\u5546");
                            } else if (Constant.TERMS_TYPE_SUPPLIER == supplierType) {
                                bo.setSupplierTypeStr("\u4f9b\u5e94\u5546+\u91c7\u8d2d\u5546");
                            } else {
                                bo.setSupplierTypeStr("-");
                            }
                        }
                    } else {
                        bo.setTemplateTypeStr("");
                    }
                }
                boList.add(bo);
            }
            rspBO.setRows(boList);
            rspBO.setPageNo(page.getPageNo());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setCode("0000");
            rspBO.setMessage("\u5408\u540c\u6a21\u677f\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setCode("8888");
            rspBO.setMessage("\u5931\u8d25");
        }
        return rspBO;
    }

    @PostMapping(value={"selectByContractTemplateId"})
    public ContractTemplateConfigBO selectByContractTemplateId(@RequestBody ContractTemplateConfigReqBO reqBO) {
        ContractTemplateConfigBO rspBO = new ContractTemplateConfigBO();
        try {
            ContractTemplateConfigPO po = new ContractTemplateConfigPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)po);
            ContractTemplateConfigPO contractTemplateConfigPO = this.contractTemplateConfigMapper.selectByPrimaryKey(po.getContractTemplateId());
            if (contractTemplateConfigPO == null) {
                rspBO.setCode("8888");
                rspBO.setMessage("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                return rspBO;
            }
            BeanUtils.copyProperties((Object)contractTemplateConfigPO, (Object)rspBO);
            rspBO.setCode("0000");
            rspBO.setMessage("\u6210\u529f");
            return rspBO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return rspBO;
        }
    }
}

