/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.service.template.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.contract.api.template.bo.ContractTermsBO;
import com.tydic.contract.api.template.bo.ContractTermsReqBO;
import com.tydic.contract.api.template.bo.ContractTermsRspBO;
import com.tydic.contract.api.template.service.QueryContractTermsService;
import com.tydic.contract.constant.Constant;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.ContractTemplateConfigPO;
import com.tydic.contract.po.ContractTermsPO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.api.template.service.QueryContractTermsService"})
public class QueryContractTermsServiceImpl
implements QueryContractTermsService {
    private static final Logger log = LoggerFactory.getLogger(QueryContractTermsServiceImpl.class);
    @Resource
    ContractTermsMapper contractTermsMapper;

    @PostMapping(value={"queryTerms"})
    public ContractTermsRspBO queryTerms(@RequestBody ContractTermsReqBO reqBO) {
        ContractTermsRspBO rspBO = new ContractTermsRspBO();
        try {
            ContractTermsPO po = new ContractTermsPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)po);
            po.setValidStatus(Constant.VALID_STATUS_YES);
            Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            List<ContractTermsPO> list = this.contractTermsMapper.selectPage(po, (Page<ContractTemplateConfigPO>)page);
            if (CollectionUtils.isEmpty(list)) {
                rspBO.setCode("0000");
                rspBO.setMessage("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                return rspBO;
            }
            ArrayList<ContractTermsBO> termsBOList = new ArrayList<ContractTermsBO>();
            for (ContractTermsPO item : list) {
                ContractTermsBO bo = new ContractTermsBO();
                BeanUtils.copyProperties((Object)item, (Object)bo);
                termsBOList.add(bo);
            }
            rspBO.setRows(termsBOList);
            rspBO.setPageNo(page.getPageNo());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setCode("0000");
            rspBO.setMessage("\u5408\u540c\u6761\u6b3e\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setCode("8888");
            rspBO.setMessage("\u5931\u8d25");
        }
        return rspBO;
    }

    @PostMapping(value={"select"})
    public int select(@RequestBody ContractTermsReqBO reqBO) {
        int result = 0;
        if (null != reqBO) {
            if (null == reqBO.getTermCode()) {
                reqBO.setTermCode("");
            }
            if (null == reqBO.getTermName()) {
                reqBO.setTermName("");
            }
        }
        try {
            ContractTermsPO record = new ContractTermsPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)record);
            record.setValidStatus(Constant.VALID_STATUS_YES);
            result = this.contractTermsMapper.select(record);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

