/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uip.unicom.cq.base.crm.domain;

import com.tydic.uip.unicom.cq.base.crm.domain.PacketIndex;
import com.tydic.uip.unicom.cq.base.crm.domain.PacketInfo;
import com.tydic.uip.unicom.cq.base.crm.domain.PacketMsg;
import com.tydic.uip.unicom.cq.base.crm.domain.RecordType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class IntfXmlPacketInfo
implements PacketInfo {
    private Map<String, Map<String, String>> props = new LinkedHashMap<String, Map<String, String>>();
    private String intfSeq;
    private String createTime;
    private String interfaceName;
    private String labelName = "";
    private String recordId;

    @Override
    public Map<String, String> get(String packetName, RecordType recordType) {
        return this.get(packetName, 0, recordType);
    }

    @Override
    public Map<String, String> get(String packetName, int recordIndex, RecordType recordType) {
        return this.props.get(PacketIndex.generate(packetName, recordIndex, recordType));
    }

    @Override
    public String getCreateTime() {
        return this.createTime;
    }

    @Override
    public String getIntfName() {
        return this.interfaceName;
    }

    @Override
    public String getIntfSeq() {
        return this.intfSeq;
    }

    @Override
    public String getOfferOrderId() throws Exception {
        Map<String, String> properties = this.get("Public", RecordType.COLLECTION);
        if (properties != null) {
            return properties.get("ask_seq");
        }
        return null;
    }

    @Override
    public Collection<PacketMsg> getPacketMsgs() {
        ArrayList<PacketMsg> msgs = new ArrayList<PacketMsg>();
        for (String key : this.props.keySet()) {
            Map<String, String> prop = this.props.get(key);
            PacketIndex index = PacketIndex.parse(key);
            PacketMsg msg = new PacketMsg();
            msg.setName(index.getName());
            msg.setIndex(index.getIndex());
            msg.setType(index.getType());
            msg.setLabelName(this.labelName);
            msg.setProps(prop);
            msgs.add(msg);
        }
        return msgs;
    }

    @Override
    public void put(String packetName, int recordIndex, RecordType recordType, Map<String, String> properities) {
        Map<String, String> oldProps;
        String key = PacketIndex.generate(packetName, recordIndex, recordType);
        if (properities == null) {
            properities = new HashMap<String, String>();
        }
        if ((oldProps = this.props.get(key)) == null) {
            this.props.put(key, properities);
        } else {
            oldProps.putAll(properities);
        }
    }

    @Override
    public void put(String packetName, int recordIndex, RecordType recordType, String propName, String propValue) {
        String key = PacketIndex.generate(packetName, recordIndex, recordType);
        Map<String, String> oldProps = this.props.get(key);
        if (oldProps == null) {
            oldProps = new HashMap<String, String>();
            this.props.put(key, oldProps);
        }
        oldProps.put(propName, propValue);
    }

    @Override
    public Map<String, String> remove(String packetName, int recordIndex, RecordType recordType) {
        String key = PacketIndex.generate(packetName, recordIndex, recordType);
        return this.props.remove(key);
    }

    @Override
    public Map<String, String> remove(String packetName, RecordType recordType) {
        return this.remove(packetName, 0, recordType);
    }

    @Override
    public Collection<PacketMsg> getPacketMsgs(String packetName) {
        ArrayList<PacketMsg> list = null;
        Collection<PacketMsg> msgs = this.getPacketMsgs();
        if (msgs != null && msgs.size() > 0) {
            list = new ArrayList<PacketMsg>();
            for (PacketMsg msg : msgs) {
                if (!msg.getName().equals(packetName)) continue;
                list.add(msg);
            }
        }
        return list;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Collection<PacketMsg> msgs = this.getPacketMsgs();
        Iterator<PacketMsg> it = msgs.iterator();
        while (it.hasNext()) {
            buffer.append(it.next()).append("\n");
        }
        return buffer.toString();
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setInfName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public void setIntfSeq(String intfSeq) {
        this.intfSeq = intfSeq;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public void setLabelName(String rootName) {
        this.labelName = rootName;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }
}

