/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uip.unicom.cq.base.crm.domain;

import com.tydic.uip.unicom.cq.base.crm.domain.RecordType;
import java.util.StringTokenizer;

public class PacketIndex {
    private static final String DELIM = "&$$&";
    private String name;
    private int index;
    private RecordType type;

    public PacketIndex(String name, int index, RecordType type) {
        if (name == null | index < 0) {
            throw new RuntimeException("Invalid Argument.");
        }
        this.name = name;
        this.index = index;
        this.type = type;
    }

    public static String generate(PacketIndex index) {
        return index.getString();
    }

    public static String generate(String name, int index, RecordType type) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(name).append(DELIM).append(index).append(DELIM).append((Object)type);
        return buffer.toString();
    }

    public static PacketIndex parse(String str) {
        StringTokenizer st = new StringTokenizer(str, DELIM);
        String name = st.nextToken();
        String index = st.nextToken();
        String type = st.nextToken();
        return new PacketIndex(name, Integer.parseInt(index), RecordType.parse(type));
    }

    public String getString() {
        return PacketIndex.generate(this.name, this.index, this.type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public RecordType getType() {
        return this.type;
    }

    public void setType(RecordType type) {
        this.type = type;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("name=").append(this.name).append(", index=").append(this.index).append(", type=").append((Object)this.type);
        return buffer.toString();
    }
}

