/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uip.unicom.cq.base.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

public class TinPfQueue
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ORDER_TYPE_INVALID = 0;
    public static final int ORDER_TYPE_ACCEPT = 1;
    public static final int ORDER_TYPE_SCAPLE = 2;
    public static final int ORDER_TYPE_STOP = 3;
    public static final int STATE_ERROR = -1;
    public static final int STATE_WAIT = 0;
    public static final int STATE_SUCCESS = 1;
    public static final int STATE_DEALING = 2;
    public static final int STATE_FAILURE = 3;
    public static final int STATE_PLATFORM_DEALING = 4;
    public static final int STATE_ADDITION_WAIT = 5;
    public static final int STATE_FATAL = 6;
    public static final String STATE_MSG_ERROR = "\u63a5\u53e3\u5904\u7406\u5931\u8d25";
    public static final String STATE_MSG_WAIT = "\u672a\u5904\u7406";
    public static final String STATE_MSG_SUCCESS = "\u5904\u7406\u6210\u529f";
    public static final String STATE_MSG_DEALING = "\u5bf9\u65b9\u7cfb\u7edf\u6b63\u5904\u7406";
    public static final String STATE_MSG_FAILURE = "\u6700\u7ec8\u5931\u8d25";
    public static final String STATE_MSG_PLATFORM_DEALING = "\u63a5\u53e3\u7a0b\u5e8f\u6b63\u5904\u7406";
    public static final int TASK_PROPERTY_INVALID = -1;
    public static final int TASK_PROPERTY_NORMAL = 0;
    public static final int TASK_PROPERTY_AGAIN = 1;
    public static final int TASK_PROPERTY_RELEASE = 2;
    private BigDecimal id;
    private String orderId;
    private int orderType = 1;
    private int taskProperty = 0;
    private int state;
    private int orderAction;
    private String errDesc;
    private long srcTacheId;
    private long sendTacheId;
    private long sendSiteId;
    private int dealLevel;
    private int dealTimes;
    private String taskId;
    private Date createTime;
    private Date bespokeTime;
    private Date lastTime;
    private String retState;
    private String retDesc;
    private Date retTime;
    private Date finishTime;
    private Date currentTime;
    private boolean reSendIfError = true;
    private boolean stateChanged;
    private boolean indexNoTacheId;
    private boolean updated;
    private String destIntfId;
    private int queueSort;

    public static TinPfQueue newInstance(String orderId, long tacheId, int orderType, int taskProperty) {
        TinPfQueue order = new TinPfQueue();
        order.setOrderId(orderId);
        order.setSendTacheId(tacheId);
        order.setOrderType(orderType);
        order.setTaskProperty(taskProperty);
        order.setState(1);
        return order;
    }

    public static TinPfQueue cloneInstance(TinPfQueue order) {
        TinPfQueue o = new TinPfQueue();
        o.id = order.id;
        o.orderId = order.orderId;
        o.orderType = order.orderType;
        o.taskProperty = order.taskProperty;
        o.state = order.state;
        o.orderAction = order.orderAction;
        o.errDesc = order.errDesc;
        o.srcTacheId = order.srcTacheId;
        o.sendTacheId = order.sendTacheId;
        o.sendSiteId = order.sendSiteId;
        o.dealLevel = order.dealLevel;
        o.dealTimes = order.dealTimes;
        o.taskId = order.taskId;
        o.createTime = order.createTime;
        o.lastTime = order.lastTime;
        o.retState = order.retState;
        o.retDesc = order.retDesc;
        o.retTime = order.retTime;
        o.finishTime = order.finishTime;
        o.currentTime = order.currentTime;
        o.reSendIfError = order.reSendIfError;
        o.stateChanged = order.stateChanged;
        o.indexNoTacheId = order.indexNoTacheId;
        o.destIntfId = order.destIntfId;
        o.queueSort = order.queueSort;
        return o;
    }

    public static boolean checkOrderPropsValid(TinPfQueue order) {
        if (order.getTaskId() != null && order.getTaskId().length() > 0) {
            return true;
        }
        if (order.getOrderId() == null) {
            return false;
        }
        return order.getSendTacheId() > 0L;
    }

    public static boolean isReleaseOrderType(TinPfQueue order) {
        return order.getTaskProperty() == 2;
    }

    public static boolean isNormalOrderType(TinPfQueue order) {
        return order.getTaskProperty() == 0;
    }

    public static boolean isAgainOrderType(TinPfQueue order) {
        return order.getTaskProperty() == 1;
    }

    public TinPfQueue() {
    }

    public TinPfQueue(String orderId) {
        this.orderId = orderId;
    }

    protected String formatTime(String timeStr) {
        return "";
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public int getOrderType() {
        return this.orderType;
    }

    public void setOrderType(int orderType) {
        this.orderType = orderType;
    }

    public int getTaskProperty() {
        return this.taskProperty;
    }

    public void setTaskProperty(int taskProperty) {
        this.taskProperty = taskProperty;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        this.stateChanged = true;
    }

    public void setNoChangeRecordState(int state) {
        this.state = state;
    }

    public int getNoChangeRecordState() {
        return this.state;
    }

    public String getErrDesc() {
        String destIntfDesc = this.destIntfId;
        return this.errDesc;
    }

    public void setErrDesc(String errDesc) {
        this.errDesc = errDesc;
    }

    public long getSendTacheId() {
        return this.sendTacheId;
    }

    public void setSendTacheId(long sendTacheId) {
        this.sendTacheId = sendTacheId;
    }

    public long getSendSiteId() {
        return this.sendSiteId;
    }

    public void setSendSiteId(long sendSiteId) {
        this.sendSiteId = sendSiteId;
    }

    public int getDealLevel() {
        return this.dealLevel;
    }

    public void setDealLevel(int dealLevel) {
        this.dealLevel = dealLevel;
    }

    public int getDealTimes() {
        return this.dealTimes;
    }

    public void setDealTimes(int dealTimes) {
        this.dealTimes = dealTimes;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getLastTime() {
        return this.lastTime;
    }

    public void setLastTime(Date lastTime) {
        this.lastTime = lastTime;
    }

    public String getRetState() {
        return this.retState;
    }

    public void setRetState(String retState) {
        this.retState = retState;
    }

    public String getRetDesc() {
        return this.retDesc;
    }

    public void setRetDesc(String retDesc) {
        this.retDesc = retDesc;
    }

    public Date getRetTime() {
        return this.retTime;
    }

    public void setRetTime(Date retTime) {
        this.retTime = retTime;
    }

    public Date getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public Date getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(Date currentTime) {
        this.currentTime = currentTime;
    }

    public BigDecimal getId() {
        return this.id;
    }

    public void setId(BigDecimal id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TinPfQueue: {id=").append(this.id).append(", taskId=").append(this.taskId).append(", orderId=").append(this.orderId).append(", orderType=").append(this.orderType).append(", taskProperty=").append(this.taskProperty).append(", orderAction=").append(this.orderAction).append(", state=").append(this.state).append(", errDesc=").append(this.errDesc).append(", tacheId=").append(this.sendTacheId).append(", siteId=").append(this.sendSiteId).append(", dealLevel=").append(this.dealLevel).append(", dealTimes=").append(this.dealTimes).append(", createTime=").append(this.createTime).append(", lastTime=").append(this.lastTime).append(", retState=").append(this.retState).append(", retDesc=").append(this.retDesc).append(", retTime=").append(this.retTime).append(", finishTime=").append(this.finishTime).append(", currentTime=").append(this.currentTime).append(", reSendIfError=").append(this.reSendIfError).append(", stateChanged=").append(this.stateChanged).append(", indexNoTacheId=").append(this.indexNoTacheId).append("}");
        return buffer.toString();
    }

    public String getRawString() {
        return super.toString();
    }

    public int getOrderAction() {
        return this.orderAction;
    }

    public void setOrderAction(int orderAction) {
        this.orderAction = orderAction;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public boolean isReSendIfError() {
        return this.reSendIfError;
    }

    public void setReSendIfError(boolean reSendIfError) {
        this.reSendIfError = reSendIfError;
    }

    public boolean isStateChanged() {
        return this.stateChanged;
    }

    public void setStateChanged(boolean stateChanged) {
        this.stateChanged = stateChanged;
    }

    public boolean isIndexNoTacheId() {
        return this.indexNoTacheId;
    }

    public void setIndexNoTacheId(boolean indexNoTacheId) {
        this.indexNoTacheId = indexNoTacheId;
    }

    public long getSrcTacheId() {
        return this.srcTacheId;
    }

    public void setSrcTacheId(long srcTacheId) {
        this.srcTacheId = srcTacheId;
    }

    public void setDestIntfId(String destIntfId) {
        this.destIntfId = destIntfId;
    }

    public String getDestIntfId() {
        return this.destIntfId;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public int getQueueSort() {
        return this.queueSort;
    }

    public void setQueueSort(int queueSort) {
        this.queueSort = queueSort;
    }

    public Date getBespokeTime() {
        return this.bespokeTime;
    }

    public void setBespokeTime(Date bespokeTime) {
        this.bespokeTime = bespokeTime;
    }
}

