/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uip.unicom.cq.module.active.photo.ws;

import com.tydic.uip.unicom.cq.module.active.photo.ws.CqSoapBindingStub;
import com.tydic.uip.unicom.cq.module.active.photo.ws.InterfaceCQ;
import com.tydic.uip.unicom.cq.module.active.photo.ws.InterfaceCQService;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class InterfaceCQServiceLocator
extends Service
implements InterfaceCQService {
    private String cq_address = "http://221.208.196.29/services/cq";
    private String cqWSDDServiceName = "cq";
    private HashSet ports = null;

    public InterfaceCQServiceLocator() {
    }

    public InterfaceCQServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public InterfaceCQServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    @Override
    public String getcqAddress() {
        return this.cq_address;
    }

    public String getcqWSDDServiceName() {
        return this.cqWSDDServiceName;
    }

    public void setcqWSDDServiceName(String name) {
        this.cqWSDDServiceName = name;
    }

    @Override
    public InterfaceCQ getcq() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.cq_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getcq(endpoint);
    }

    @Override
    public InterfaceCQ getcq(URL portAddress) throws ServiceException {
        try {
            CqSoapBindingStub _stub = new CqSoapBindingStub(portAddress, this);
            _stub.setPortName(this.getcqWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setcqEndpointAddress(String address) {
        this.cq_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (InterfaceCQ.class.isAssignableFrom(serviceEndpointInterface)) {
                CqSoapBindingStub _stub = new CqSoapBindingStub(new URL(this.cq_address), this);
                _stub.setPortName(this.getcqWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("cq".equals(inputPortName)) {
            return this.getcq();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("urn:cq", "InterfaceCQService");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("urn:cq", "cq"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"cq".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setcqEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

