/*
 * Decompiled with CFR 0.152.
 */
package workflow.engine.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    private static String defaultDatePattern = "yyyy-MM-dd HH:mm:ss";

    public static String getDatePattern() {
        return defaultDatePattern;
    }

    public static String getToday() {
        Date today = new Date();
        return DateUtil.format(today);
    }

    public static String format(Date date) {
        return DateUtil.format(date, DateUtil.getDatePattern());
    }

    public static String format(Date date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return returnValue;
    }

    public static Date parse(String strDate) throws ParseException {
        return DateUtil.parse(strDate, DateUtil.getDatePattern());
    }

    public static Date parse(String strDate, String pattern) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.parse(strDate);
    }

    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Date addHour(Date date, double hour) {
        int second = (int)Math.round(hour * 3600.0);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, second);
        return cal.getTime();
    }
}

