/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.file.base;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FileConfigurationProperties {
    @Value(value="${datak.file.tmpDir}")
    private String uploadTmpDir;
    @Value(value="${datak.file.storePath}")
    private String storePath;
    @Value(value="${datak.file.suffix}")
    private String suffix;
    @Value(value="${datak.file.externalStorage}")
    private Boolean externalStorage;
    @Value(value="${datak.file.projectName}")
    private String projectName;

    public String getUploadTmpDir() {
        if (this.uploadTmpDir.contains("{catalinaPath}")) {
            String catalinaPath = this.getRootPath();
            return this.uploadTmpDir.replace("{catalinaPath}", catalinaPath);
        }
        return this.uploadTmpDir;
    }

    public void setUploadTmpDir(String uploadTmpDir) {
        this.uploadTmpDir = uploadTmpDir;
    }

    public String getStorePath() {
        if (!this.externalStorage.booleanValue()) {
            String catalinaPath = this.getRootPath();
            return this.storePath.replace("{catalinaPath}", catalinaPath);
        }
        return this.storePath;
    }

    public void setStorePath(String storePath) {
        this.storePath = storePath;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public Boolean getExternalStorage() {
        return this.externalStorage;
    }

    public void setExternalStorage(Boolean externalStorage) {
        this.externalStorage = externalStorage;
    }

    private String getRootPath() {
        String catalinaPath = this.getClass().getResource("/").getPath().replaceAll("WEB-INF/classes/", this.projectName + "/");
        return catalinaPath;
    }
}

