/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.file.base;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FileDBDataSourceConfig {
    @Value(value="${datak.file.driver-class-name}")
    private String driver;
    @Value(value="${datak.file.url}")
    private String url;
    @Value(value="${datak.file.username}")
    private String username;
    @Value(value="${datak.file.password}")
    private String password;
    @Value(value="${datak.file.DbPath}")
    private String DbPath;
    @Value(value="${datak.file.continue-on-error}")
    private Boolean continueOnError;
    @Value(value="${datak.file.hibernate.ddl-auto}")
    private String hibernateDDLAuto;
    @Value(value="${datak.file.hibernate.showSql}")
    private Boolean hibernateShowSql;
    @Value(value="${datak.file.hibernate.dialect}")
    private String hibernateDialect;
    @Value(value="${datak.file.initialize.scriptPath}")
    private String initScriptPath;
    @Value(value="${datak.file.initialize.able}")
    private Boolean initializeAble;
    @Value(value="${datak.file.initialize.scriptName}")
    private String initScriptName;
    @Value(value="${datak.file.projectName}")
    private String projectName;
    @Value(value="${datak.file.test-while-idle}")
    private Boolean testWhildIdle;
    @Value(value="${datak.file.validation-query}")
    private String validationQuery;

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        if (this.url.contains("{catalinaPath}")) {
            String catalinaPath = this.getRootPath();
            return this.url.replace("{catalinaPath}", catalinaPath);
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDbPath() {
        return this.DbPath;
    }

    public void setDbPath(String dbPath) {
        this.DbPath = dbPath;
    }

    public Boolean getContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(Boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public String getHibernateDDLAuto() {
        return this.hibernateDDLAuto;
    }

    public void setHibernateDDLAuto(String hibernateDDLAuto) {
        this.hibernateDDLAuto = hibernateDDLAuto;
    }

    public Boolean getHibernateShowSql() {
        return this.hibernateShowSql;
    }

    public void setHibernateShowSql(Boolean hibernateShowSql) {
        this.hibernateShowSql = hibernateShowSql;
    }

    public String getHibernateDialect() {
        return this.hibernateDialect;
    }

    public void setHibernateDialect(String hibernateDialect) {
        this.hibernateDialect = hibernateDialect;
    }

    public String getInitScriptPath() {
        if (this.initScriptPath.contains("{catalinaPath}")) {
            String catalinaPath = this.getRootPath();
            return this.initScriptPath.replace("{catalinaPath}", catalinaPath);
        }
        return this.initScriptPath;
    }

    public void setInitScriptPath(String initScriptPath) {
        this.initScriptPath = initScriptPath;
    }

    public String getInitScriptName() {
        return this.initScriptName;
    }

    public void setInitScriptName(String initScriptName) {
        this.initScriptName = initScriptName;
    }

    public Boolean getInitializeAble() {
        return this.initializeAble;
    }

    public void setInitializeAble(Boolean initializeAble) {
        this.initializeAble = initializeAble;
    }

    public Boolean getTestWhildIdle() {
        return this.testWhildIdle;
    }

    public void setTestWhildIdle(Boolean testWhildIdle) {
        this.testWhildIdle = testWhildIdle;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    private String getRootPath() {
        String catalinaPath = this.getClass().getResource("/").getPath().replaceAll("WEB-INF/classes/", this.projectName + "/");
        return catalinaPath;
    }
}

