/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.file.base;

import com.alibaba.druid.pool.DruidDataSource;
import com.tydic.datakbase.file.base.FileDBDataSourceConfig;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.PersistenceContext;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.h2.server.web.WebServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableJpaRepositories(basePackages={"com.tydic.datakbase.file"}, entityManagerFactoryRef="fileDataSourceEntityManagerFactory", transactionManagerRef="fileDataSourceTransactionManager")
@Order(value=1)
@EnableTransactionManagement
public class FileDBJpaConfigurer {
    private static final Logger log = LoggerFactory.getLogger(FileDBJpaConfigurer.class);
    @Autowired
    private FileDBDataSourceConfig config;

    public DataSourceProperties fileDataSourceProperties() {
        DataSourceProperties dataSourceProperties = new DataSourceProperties();
        dataSourceProperties.setType(DruidDataSource.class);
        dataSourceProperties.setDriverClassName(this.config.getDriver());
        dataSourceProperties.setUrl(this.config.getUrl());
        dataSourceProperties.setUsername(this.config.getUsername());
        dataSourceProperties.setPassword(this.config.getPassword());
        dataSourceProperties.setContinueOnError(this.config.getContinueOnError().booleanValue());
        return dataSourceProperties;
    }

    @Bean(value={"fileDataSource"})
    public DataSource fileDataSource() {
        DataSourceProperties dataSourceProperties = this.fileDataSourceProperties();
        return dataSourceProperties.initializeDataSourceBuilder().build();
    }

    public DataSource druidDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.config.getUrl());
        datasource.setUsername(this.config.getUsername());
        datasource.setPassword(this.config.getPassword());
        datasource.setDriverClassName(this.config.getDriver());
        datasource.setInitialSize(5);
        datasource.setValidationQuery(this.config.getValidationQuery());
        datasource.setTestWhileIdle(this.config.getTestWhildIdle().booleanValue());
        return datasource;
    }

    @Bean(value={"fileDataSourceTransactionManager"})
    public PlatformTransactionManager fileDataSourceTransactionManager(EntityManagerFactoryBuilder builder) {
        JpaTransactionManager tm = new JpaTransactionManager();
        tm.setEntityManagerFactory(this.fileDataSourceEntityManagerFactory(builder).getObject());
        tm.setDataSource(this.druidDataSource());
        return tm;
    }

    @PersistenceContext(name="dataFileUnitName")
    @Bean(value={"fileDataSourceEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean fileDataSourceEntityManagerFactory(EntityManagerFactoryBuilder builder) {
        return builder.dataSource(this.druidDataSource()).persistenceUnit("dataFileUnitName").packages(new String[]{"com.tydic.datakbase.file"}).properties(this.jpaProperties()).build();
    }

    @Bean(value={"fileDataSourceInitializer"})
    public DataSourceInitializer fileDataSourceInitializer() {
        log.info("begin executer initialize script {}...", (Object)(this.config.getInitScriptPath() + this.config.getInitScriptName()));
        DataSourceInitializer dsInitializer = new DataSourceInitializer();
        dsInitializer.setDataSource(this.fileDataSource());
        ResourceDatabasePopulator dbPopulator = new ResourceDatabasePopulator();
        dbPopulator.setContinueOnError(this.config.getContinueOnError().booleanValue());
        dbPopulator.addScript((Resource)new FileSystemResource(new File(this.config.getInitScriptPath() + this.config.getInitScriptName())));
        dsInitializer.setDatabasePopulator((DatabasePopulator)dbPopulator);
        dsInitializer.setEnabled(this.config.getInitializeAble().booleanValue());
        return dsInitializer;
    }

    @Bean
    public ServletRegistrationBean h2Servlet() {
        ServletRegistrationBean h2Servlet = new ServletRegistrationBean((Servlet)new WebServlet(), new String[0]);
        h2Servlet.addInitParameter("webAllowOthers", "");
        h2Servlet.setName("h2Servlet");
        h2Servlet.addUrlMappings(new String[]{"/h2/*"});
        return h2Servlet;
    }

    private Map<String, Object> jpaProperties() {
        HashMap<String, Object> jpaProperties = new HashMap<String, Object>();
        jpaProperties.put("hibernate.hbm2ddl.auto", this.config.getHibernateDDLAuto());
        jpaProperties.put("hibernate.show-sql", this.config.getHibernateShowSql());
        jpaProperties.put("hibernate.dialect", this.config.getHibernateDialect());
        jpaProperties.put("hibernate.ejb.entitymanager_factory_name", "fileEntityManager");
        return jpaProperties;
    }
}

