/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.file.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class JpaOption {
    private List<Param> params = new ArrayList<Param>();
    private String order;

    public JpaOption addParam(String name, String operator, Object value) {
        this.params.add(new Param(name, operator, value));
        return this;
    }

    public List<Param> getParams() {
        return this.params;
    }

    public void setParams(List<Param> params) {
        this.params = params;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public class Param {
        private String name;
        private String operator;
        private Object value;

        public Param(String name, String operator, Object value) {
            this.name = name;
            this.operator = operator;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public String getValue() {
            if (null == this.value) {
                return "";
            }
            if (this.value instanceof Collection) {
                StringBuilder reBulid = new StringBuilder();
                Iterator iterator = ((Collection)this.value).iterator();
                while (iterator.hasNext()) {
                    reBulid.append("'").append(iterator.next()).append("',");
                }
                reBulid.deleteCharAt(reBulid.length() - 1);
                return reBulid.toString();
            }
            return "'" + this.value.toString() + "'";
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getOption() {
            String option = "";
            switch (this.getOperator()) {
                case "in": 
                case "not in": {
                    option = this.getName() + " " + this.getOperator() + " (" + this.getValue() + ")";
                    break;
                }
                default: {
                    option = this.getName() + " " + this.getOperator() + " " + this.getValue() + "";
                }
            }
            return option;
        }
    }
}

