/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.datakbase.file.service.impl;

import com.tydic.datakbase.file.dao.FileModelRepository;
import com.tydic.datakbase.file.model.FileModel;
import com.tydic.datakbase.file.service.FileModelService;
import com.tydic.datakbase.file.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class FileModelServiceImpl
implements FileModelService {
    private Logger logger = LoggerFactory.getLogger(FileModelServiceImpl.class);
    @Autowired
    private FileModelRepository fileModelRepository;

    @Override
    public String checkMD5(String fileMD5) {
        FileModel fileModel;
        if (Utils.isNotBlank((CharSequence)fileMD5) && null != (fileModel = this.fileModelRepository.findByMD5(fileMD5)) && Utils.isNotBlank((CharSequence)fileModel.getPath())) {
            return fileModel.getPath();
        }
        return "-1";
    }

    @Override
    public String saveFileModel(FileModel fileModel) {
        FileModel has = this.fileModelRepository.findByMD5(fileModel.getMD5());
        if (null != has) {
            return has.getPath();
        }
        FileModel response = (FileModel)this.fileModelRepository.save(fileModel);
        if (null == response) {
            return "-1";
        }
        return response.getPath();
    }

    @Override
    public boolean deleteFileModel(Long id) {
        if (this.fileModelRepository.existsById(id)) {
            this.fileModelRepository.deleteById(id);
        }
        return true;
    }

    @Override
    public boolean deleteFileModelByMD5(String MD5) {
        FileModel deleteModel = this.fileModelRepository.findByMD5(MD5);
        if (null != deleteModel) {
            this.fileModelRepository.deleteById(deleteModel.getId());
        }
        return true;
    }

    @Override
    public FileModel findFileModel(Long id) {
        FileModel fileModel = (FileModel)this.fileModelRepository.getOne(id);
        return fileModel;
    }

    @Override
    public FileModel findFileModelByMD5(String MD5) {
        FileModel fileModel = this.fileModelRepository.findByMD5(MD5);
        return fileModel;
    }

    @Override
    public boolean updateFileModel(FileModel fileModel) {
        FileModel response = (FileModel)this.fileModelRepository.save(fileModel);
        return null != response;
    }

    @Override
    public List<FileModel> getAllFile() {
        List fileModelIterable = this.fileModelRepository.findAll();
        ArrayList<FileModel> fileModelList = new ArrayList<FileModel>();
        fileModelIterable.forEach(fileModel -> fileModelList.add((FileModel)fileModel));
        return fileModelList;
    }

    @Override
    public Map<String, Object> getAllFile(Integer page, Integer pageSize) {
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"createTime"});
        PageRequest pageable = new PageRequest(page - 1, pageSize.intValue(), sort);
        Page<FileModel> fileModelPage = this.fileModelRepository.findAll((Pageable)pageable);
        HashMap<String, Object> pageInfo = new HashMap<String, Object>();
        pageInfo.put("list", fileModelPage.getContent());
        pageInfo.put("count", fileModelPage.getContent().size());
        pageInfo.put("totalCount", fileModelPage.getTotalElements());
        pageInfo.put("totalPages", fileModelPage.getTotalPages());
        return pageInfo;
    }

    @Override
    public boolean setUseAble(Long id, boolean able) {
        FileModel fileModel = (FileModel)this.fileModelRepository.getOne(id);
        if (null != fileModel) {
            fileModel.setUseAble(able);
            FileModel response = (FileModel)this.fileModelRepository.save(fileModel);
            return true;
        }
        return false;
    }

    @Override
    public List<Long> exportFileModels(List<String> MD5List, String destDirPath) throws IOException {
        if (null == MD5List || MD5List.isEmpty()) {
            return null;
        }
        ArrayList<Long> idList = new ArrayList<Long>();
        List<FileModel> fileModels = this.fileModelRepository.findByMD5List(MD5List);
        if (null != fileModels && !fileModels.isEmpty()) {
            for (FileModel fileModel : fileModels) {
                idList.add(fileModel.getId());
            }
        }
        return idList;
    }
}

