app.controller('fileManager', ['fileManagerService', 'Constant', '$scope',
    function (fileManagerService, Constant, $scope) {
        $scope.fileMD5 = "";
        $scope.imagePath = Constant.imagePath;
        $scope.downloadPath = Constant.downloadPath;
        $scope.pageNoList = [];
        $scope.upload = function () {
            $.getFileMD5("file", function (data) {
                $scope.fileMD5 = data;
                var result = fileManagerService.checkFileMD5($scope.fileMD5);
                if (result.flag == 1) {
                    if (result.data != -1) {
                        $scope.filePath = result.data;
                        if (!$scope.$$phase) {
                            $scope.$apply();
                        }
                        return;
                    }
                    var file = $("#file")[0].files[0];
                    result = fileManagerService.uploadFile(file, $scope.fileMD5);
                    if (result.flag == 1) {
                        if (result.data != -1) {
                            $scope.filePath = result.data;
                            $scope.initList();
                            return;
                        }
                    }
                }
            });

        };


        $scope.initPageNoList = function (currPage, totalPage) {
            var pageNoList = [];
            for (var i = 1; i <= totalPage; i++) {
                var item = {
                    pageNo: i
                };
                if (currPage < 6) {
                    if (i > 10) {
                        continue;
                    }
                } else {
                    if (i <= currPage - 5 || i > currPage + 4) {
                        continue;
                    }
                }
                pageNoList.push(item);
            }
            return pageNoList;
        };

        $scope.initList = function (page) {
            $scope.currPage=page;
            var pageInfo=fileManagerService.getFileList(page,5);
            $scope.fileList=pageInfo.list;
            $scope.totlePages=pageInfo.totalPages;
            $scope.pageNoList=$scope.initPageNoList(page,pageInfo.totalPages);
            console.log($scope.fileList);
            if (!$scope.$$phase) {
                $scope.$apply();
            }
        };
        $scope.prevPage=function(){
            if($scope.currPage==1)
                return;
            $scope.initList($scope.currPage-1);
        };
        $scope.nextPage=function(){
            if($scope.currPage==$scope.totlePages)
                return;
            $scope.initList($scope.currPage+1);
        };
        $scope.toPage=function(pageNo){
            $scope.initList(pageNo);
        };

        $scope.initList(1);

        $scope.deleteFile = function (id) {
            var result = fileManagerService.deleteFile(id);
            $scope.initList($scope.currPage);
        };

        $scope.exportFile=function(){
            var urlList=[];
            for(var i in $scope.fileList){
                var file=$scope.fileList[i];
                urlList.push($scope.imagePath+file.path);
            }
            var filePath=$scope.exportPath+"/file";
            var dbPath=$scope.exportPath+"/db";
            var result=fileManagerService.exportFile(urlList,filePath,dbPath);
            console.log(result);
        };

        $scope.setUseAble=function(id,able){
            fileManagerService.setFileUserAble(id,able);
            $scope.initList($scope.currPage);
        };


    }]);