$(function(){
    $.fn.extend({
        getMD5:function(id,callback){
            var blobSlice = File.prototype.slice || File.prototype.mozSlice || File.prototype.webkitSlice,
            file = document.getElementById(id).files[0],
            chunkSize = 2097152,                             // Read in chunks of 2MB
            chunks = Math.ceil(file.size / chunkSize),
            currentChunk = 0,
            spark = new SparkMD5.ArrayBuffer(),
            fileReader = new FileReader();
            var md5 = null;
         
            fileReader.onload = function (e) {
                console.log('read chunk nr', currentChunk + 1, 'of', chunks);
                spark.append(e.target.result);                   // Append array buffer
                currentChunk++;
        
                if (currentChunk < chunks) {
                    loadNext();
                } else {
                    console.log('finished loading');
                    console.info('computed hash', spark.end());  // Compute hash
                    md5 = spark.end();
                    if(typeof callback ==='function'){
                        callback(md5);
                    };
                    // document.getElementById("info").innerText="文件的MD5值："+spark.end();
                }
            };

            fileReader.onerror = function () {
                console.warn('oops, something went wrong.');
            };
        
            function loadNext() {       //分片读取
                var start = currentChunk * chunkSize,
                    end = ((start + chunkSize) >= file.size) ? file.size : start + chunkSize;
        
                fileReader.readAsArrayBuffer(blobSlice.call(file, start, end));
            }
            loadNext();
        }
    });
    $.extend({
        getFileMD5:function(id,callback){
            var blobSlice = File.prototype.slice || File.prototype.mozSlice || File.prototype.webkitSlice,
                file = document.getElementById(id).files[0],
                chunkSize = 2097152,                             // Read in chunks of 2MB
                chunks = Math.ceil(file.size / chunkSize),
                currentChunk = 0,
                spark = new SparkMD5.ArrayBuffer(),
                fileReader = new FileReader();
            var md5 = null;

            fileReader.onload = function (e) {
                console.log('read chunk nr', currentChunk + 1, 'of', chunks);
                spark.append(e.target.result);                   // Append array buffer
                currentChunk++;

                if (currentChunk < chunks) {
                    loadNext();
                } else {
                    console.log('finished loading');
                    md5 = spark.end();
                    if(typeof callback ==='function'){
                        callback(md5);
                    };
                    // document.getElementById("info").innerText="文件的MD5值："+spark.end();
                }
            };

            fileReader.onerror = function () {
                console.warn('oops, something went wrong.');
            };

            function loadNext() {       //分片读取
                var start = currentChunk * chunkSize,
                    end = ((start + chunkSize) >= file.size) ? file.size : start + chunkSize;

                fileReader.readAsArrayBuffer(blobSlice.call(file, start, end));
            }
            loadNext();
        },
        getArrayBufferMd5:function(buffer){
            var spark = new SparkMD5.ArrayBuffer();
            spark.append(buffer);
            return spark.end();
        }
    });
})